(function( factory ){
	if ( typeof define === 'function' && define.amd ) {
		// AMD
		define( ['jquery', 'datatables.net'], function ( $ ) {
			return factory( $, window, document );
		} );
	}
	else if ( typeof exports === 'object' ) {
		// CommonJS
		module.exports = function (root, $) {
			if ( ! root ) {
				root = window;
			}

			if ( ! $ || ! $.fn.dataTable ) {
				$ = require('datatables.net')(root, $).$;
			}

			return factory( $, root, root.document );
		};
	}
	else {
		// Browser
		factory( jQuery, window, document );
	}
}(function( $, window, document, undefined ) {
	var DataTable = $.fn.dataTable;

	var ClearSearch = function ( dt, opts ) {
		if ( ! (this instanceof ClearSearch) ) {
			alert( "ClearSearch warning: ClearSearch must be initialised with the 'new' keyword." );
			return;
		}

		if ( ! DataTable.versionCheck || ! DataTable.versionCheck( '1.10.8' ) ) {
			throw( "Warning: ClearSearch requires DataTables 1.10.8 or greater");
		}		
		if ( opts === undefined ) {
			opts = {};
		}
		
		this.s = {
			/**
			 * DataTables settings object
			 *  @type     object
			 *  @default  Passed in as first parameter to constructor
			 */
			//"dt": $.fn.dataTable.Api( dt ).settings()[0]
			dt: new DataTable.Api( dt ),
		};
		this.s = $.extend( this.s, ClearSearch.oDefaults, opts );

		this.dom = {
			container: $('<span/>').addClass( 'clearsearch-close' )
		};

		if ( this.s.dt.oClearSearch ) {
			return;
		}
		this.s.dt.oClearSearch = this;
		this._constructor();
	};

	$.extend( ClearSearch.prototype, {
		_constructor: function () {
			var that = this;
			var dt = this.s.dt;
			var container = this.s.dt.table().container();
			var $dtFilter = $('div.dataTables_filter', container);
			$('.dataTables_filter input[type="search"]', container).addClass('clearsearch');
			if ($dtFilter.length) {
				this.dom.dtFilter = $dtFilter;
				if (!$('span', $dtFilter).length) {		// only add Close button once
					$dtFilter.append(this.dom.container);
					this.dom.container.on('click', function(e) {
						dt.search('').draw();
					});
				}
			}
		}
	} );

	// Attach a listener to the document which listens for DataTables initialisation
	// events so we can automatically initialise
	$(document).on( 'init.dt plugin-init.dt', function (e, settings, json) {
		if ( e.namespace !== 'dt' ) {
			return;
		}

		var init = settings.oInit.clearSearch;
		var defaults = DataTable.defaults.clearSearch;

		if ( init || defaults ) {
			var opts = $.extend( {}, init, defaults );

			if ( init !== false ) {
				new ClearSearch( settings, opts  );
			}
		}
	} );

	var isIOS = navigator.platform.match(/(iPhone|iPod|iPad)/i);
	if (window.chrome && window.chrome.webstore) {		// not for Chrome on Windows
		var isMac = navigator.platform.toUpperCase().indexOf('MAC') > -1;
		DataTable.defaults.clearSearch = isMac;
	} else if (typeof InstallTrigger != 'undefined') {	// Firefox
		DataTable.defaults.clearSearch = true;
	} else if (Object.prototype.toString.call(window.HTMLElement).indexOf('Constructor') > 0) {	// Safari
		DataTable.defaults.clearSearch = true;
	} else {
		DataTable.defaults.clearSearch = isIOS;
	}
	
	// DataTables `dom` feature option
	DataTable.ext.feature.push( {
		fnInit: function( settings ) {
			var api = new DataTable.Api( settings );
			var opts = api.init().clearSearch || DataTable.defaults.clearSearch;

			return new ClearSearch( api, opts ).container();
		},
		cFeature: "S"
	} );

	return ClearSearch;
}));

