<?php

// pkp:  small, fast, powerful
//  http://www.myopenticket.com/admin/test
//  http://php.net/manual/en/language.oop5.magic.php

// scan for changes whenever module added/removed/updated
//  or when special file missing

// modules have dependencies - must be present (maybe autoload them?)

// modules:
//   core pkp
//   database, table name, sql builder, table version system
//   themes
//   server status, os, active webserver, etc, memory, free space, etc, domainname
//   input: get parameters - web or cmdline, files, hostname
//   get/set settings; encryption key
//   users (everything encrypted - username, email, password; some items are also hashed - username, email)
//   module to run a command  as root (or any) user using ssh, or client app
//   fancy/debug error messages
//   profiling / queries / etc

// controller:  name[__GET] / name__POST / name__PATCH / name__DELETE / name_PUT

// when loading controller: if out of date, rebuild special file

// extends model, database

// for each modules:
//  special loader file - title, configuration items, dependencies, hooks, table definitions, table prefix?
//  configuration entries
//  table definitions; create tables on enable.  prompt to delete tables on disable

$STARTTIME = microtime(TRUE);
define('HOME', dirname(__DIR__));
//header('Content-type: text/plain');

try {
	require_once HOME . '/modules/pkpCore/model/module.php';
	require_once HOME . '/modules/pkpCore/modulemain.php';
} catch (Throwable $e) {			// php 7
	die('Error:' . $e->getMessage() . ' in ' . $e->getFile() . ' at line ' . $e->getLine() . ' [1]');
}

//error_reporting( E_ALL );
//ini_set( "display_errors", 1 );
if (isset($_SERVER['argc'])) {
    for($i = 1; $i < $_SERVER['argc']; $i++) {
        $entry = $_SERVER['argv'][$i];
        if (($p = strpos($entry, '=')) !== FALSE) {
            $key = trim(substr($entry, 0, $p));
            $value = trim(substr($entry, $p + 1));
            if ($key == 'PHPSESSID') {
                session_id($value);
                break;
            }
        }
    }
} elseif (!empty($_SERVER['QUERY_STRING'])) {
    parse_str($_SERVER['QUERY_STRING'], $temp);
    if (isset($temp['PHPSESSID'])) {
        session_id($temp['PHPSESSID']);
    }
}

session_start();
$module = load_module('pkpCore');
hook_execute('global.load');
$module->run();
hook_execute('global.done');
