<?php

namespace modules\update;

class main extends \moduleMain {

	use \modules\config\traits {
			\modules\config\traits::__construct as __ConstructConfig;
		}

	use \modules\input\traits {
			\modules\input\traits::__construct as __ConstructInput;
		}
	use \modules\output\traits {
			\modules\output\traits::__construct as __ConstructOutput;
		}
	
	public function __construct() {
		parent::__construct(__DIR__);
		$this->__ConstructConfig();
		$this->__ConstructInput();
		$this->__ConstructOutput($this->__INPUT, $this->__CONFIG);
	}
	
	public function Activate() {
	// add New Version Available column for Modules list
		hook_add('menu.admin', [$this, '__admin_menu'], 94);
	}

	public function __admin_menu(&$menu) {
		$menu[] = [
				'caption' => 'Update Modules', 
				'href' => '/admin/update', 
				'hint' => 'Update software modules',
				'icon' => '<i class="far fa-save"></i>',
				's' => 0
			];
	}

	final function install($modulename = '') {
		while (ob_get_level() > 0) {
			ob_end_flush();
		}
		$model_update = $this->LoadModel('update_model');
		if ($modulename != '') {
			header('Content-type: text/html');
			$model_update->checkCatalog($this->settings['repo'] ?? '', FALSE);
			$model_update->performInstallation($modulename);
		} else {
			header('Content-type: text/plain');
			echo "Missing module name\n";
			flush();
		}
		exit;
	}

}