<?php

namespace modules\themeDefault;

class main extends \moduleMain {

	use \modules\output\traits {
			\modules\output\traits::__construct as __ConstructOutput;
		}

	public function __construct() {
		$this->__ConstructOutput();
	}
	
	public function Activate() {
	}

	public function Button(&$result, $text, $logoclass = 'fa-envelope-o', $colorclass = 'cc-gray', $outline = FALSE) {
		if ($result == '') {
			if ($logoclass != '') {
                if (!preg_match('~\b(fa|fab|fas|far)\b~', $logoclass)) {
                    $logoclass = 'fa ' . $logoclass;
                }
				$result = <<<BLOCK
<span class="themeButton $colorclass"><i class="fa-icon $logoclass"></i><span class="btn-text logo">$text</span></span>
BLOCK;
			} else {
				$result = <<<BLOCK
<span class="themeButton $colorclass"><span class="btn-text">$text</span></span>
BLOCK;
			}
		}
	}
	
	public function __favicon(&$html) {
		$base = $this->StaticUriModule(__DIR__);
		$html = "<link type=\"image/svg\" rel=\"icon\" href=\"{$base}/bowling-ball-solid.svg\"><!-- from fontawesome -->";
	}

	// load html, css, javascript for the theme
	public function Load() {
		Hook_add('html.button', [$this, 'Button']);
		hook_add('html.favicon', [ $this, '__favicon' ], 10);
	// themes are loaded last - too late to install hooks
		$ext = $this->getJsExtension();
		
		// history: https://github.com/devote/HTML5-History-API
		$this->IncludeFile("https://cdnjs.cloudflare.com/ajax/libs/handlebars.js/4.0.6/handlebars{$ext}")
				->Version('');
		$this->IncludeFile("/static/history{$ext}")
				->Version('4.2.10');
                
		$this->IncludeFile('https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css')
				->Version('');
		$this->IncludeFile("https://code.jquery.com/ui/1.12.1/jquery-ui{$ext}", 'jquery-ui')
				->Version('')
				->depends('jquery');
		// https://cdnjs.com/libraries/font-awesome/5.12.0-1
		$this->IncludeFile('https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.12.0-1/css/all.min.css', 'awesome')
				->Integrity('sha256-4w9DunooKSr3MFXHXWyFER38WmPdm361bQS/2KUWZbU=')
				->CrossOrigin('anonymous')
				->Version('');
	}
	
	public function run($data) {

		$navigation = [];
		header('Content-type: text/html; charset=utf-8');
		echo $this->render($navigation, $data);
	}
	
	// all items are on a single line, with separators
	private function GenerateSingleLineMenu_html($menu, $icononly = FALSE) {
		$output = '';
		foreach((array)$menu as $menu_item) {
			if ($icononly) {
				$line = $menu_item['icon'];
			} else {
				$line = $menu_item['caption'];
			}
			$class = isset($menu_item['class']) ? $menu_item['class'] : '';
			$hint = isset($menu_item['hint']) ? $menu_item['hint'] : '';
			if ($hint != '') $hint = ' title="' . htmlspecialchars($hint) . '"';
			if (!empty($menu_item['href']) && $menu_item['href'] != 'false') {	//  != '' && $menu_item['href'] !== FALSE
				if ($class != '') {
					$line = "<a class=\"$class\" href=\"{$menu_item['href']}\"$hint>$line</a>";
				} else {
					$line = "<a href=\"{$menu_item['href']}\"$hint>$line</a>";
				}
			} elseif ($class != '' || $hint != '') {
				$line = "<span class=\"$class\"$hint>$line</span>";
			}
			$output .= '<span class="menuitem-single">' . $line . '</span>';
		}
		return $output;
	}
	
	private function retrieveMenu($menuname) {
		$info = hook_execute('menu.' . $menuname, []);
		// sort by display order?
		return $info;
	}
	
	private function render($navigation, $page_data) {
		$base = $this->StaticUriModule(__DIR__);
		$ext = $this->getJsExtension();

		hook_execute('html.prepare', $this, $page_data);
		// any files included here are at the end of the list
		$this->IncludeFile("/static/jquery.jeditable.css");
		$this->IncludeFile("/static/jquery.jeditable$ext")->depends('jquery');
		$this->IncludeFile($base . '/template.css');

		$title = $this->Title();
		if ($title !== NULL) {
			$dtitle = '<title>' . htmlspecialchars($title) . "</title>\n";
		} else {
			$dtitle = '';
		}

/*		$menu = $this->RetrieveMenu($displayobject, 'menu1');			// Top Left Menu
		// handle MenuEdit_Model::MENUFLAG_CUSTOM
		$menu1 = $this->GenerateProfileMenu_html($menu, FALSE);
		
		$menu = $this->RetrieveMenu($displayobject, 'menu3');			// Footer - SingleLine Menu
		$menu3 = $this->GenerateSingleLineMenu_html($menu);

		$new_nav = $this->GenerateProfileMenu_html($navigation, TRUE);	// top menu items are created right to left
*/
		$menu1 = $new_nav = '';

		$menu = $this->RetrieveMenu('menu2');			// profile menu
		$menu2 = $this->GenerateSingleLineMenu_html($menu, TRUE);
		
		$menu = $this->RetrieveMenu('menu3');			// Footer - SingleLine Menu
		$menu3 = $this->GenerateSingleLineMenu_html($menu);
		
		$body = $this->body();
		if ($body === null) $body = '';
		$body = $this->hook_apply_late($body);

		$yy = date('Y');
		$footer = <<<BLOCK
<div class="footer-container">
	<div class="main-col footer-line-1">
		<span class="t2">{$menu3}</span>
	</div>
</div>
BLOCK;
		if (hook_exists('page.footer')) {
			$footer = hook_execute('page.footer', $footer);		// executed before GetInclude so $displayobject can be modified
		}
		
		$inc = hook_execute('html.head', '');

		$favicon = $this->favIcon();
		$header_item_1 = $this->OutputGet('header_item_1', '<div class="pai_logo hdr-image"></div>');
		$header_item_2 = $this->OutputGet('header_item_2', '');
		$page_class = $this->OutputGet('page_class', '');
		if ($page_class != '') $page_class = ' class="' . $page_class . '"';
		$htmlfooter = hook_exists('html.footer') ? hook_execute('html.footer', '') : '';

		$html = <<<BLOCK
<!DOCTYPE html>
<html lang="en">
<head>
<meta name="robots" content="noindex">
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=EmulateIE7">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<meta name="MSSmartTagsPreventParsing" content="TRUE">
{$favicon}{$dtitle}{$inc}
</head>
<body>
<div id="pagecontainer">
	<div id="pagecontent"$page_class>
		<div class="page-container">
			<div class="header-container">
				<div class="header-line-1"><div class="nav-container-0">{$menu1}</div><div class="nav-container-1">$new_nav</div></div>
				<div id="headergraphic" class="header main-col">
					<span><div class="setup_logo"></div></span>
					<div class="nav-container-2">{$menu2}</div>
				</div>
				{$header_item_2}
			</div>
		
			<div id="body_container" class="body-container">
				<div id="main_content" class="body main-col font8">$body
				</div>
			</div>
			{$footer}
		</div>
	</div>
	<div class="clearfix"></div>
</div>
<div class="popup-dialog" style="display:none"></div>
{$htmlfooter}
</body>
</html>
BLOCK;

		return $html;
	}

}