<?php

namespace modules\sqlparser;


class main extends \moduleMain {
	
	public function __construct() {
		parent::__construct(__DIR__);
	}

	public function Activate() {
		hook_add('parser.mysql', [$this, '__parser']);
		hook_add('parser.tostring', [$this, '__restore']);
		$this->autoloadRegister('PHPSQLParser', __DIR__ . '/src/PHPSQLParser');
	}

	// break up into array
	public function __parser(&$result, $sql) {
		$parser = new \PHPSQLParser\PHPSQLParser;
		$result = $parser->parse($sql);
	}
	
	// restore original sql from array
	public function __restore(&$result, $parsed) {
		$creator = new \PHPSQLParser\PHPSQLCreator;
		$result = $creator->create($parsed);
	}
	
}