<?php

class Admin_View extends View {

	function render_index() {
		$html = <<<BLOCK
<div class="indented">
	<h3 class="templateheader">{{page_title}}</h3>
	<p>Please select from the items listed below:</p>
	<ul class="admin-list list-provider">
	{{#each items}}<li><a href="{{href}}" class="adminButton"{{#if hint}} title="{{hint}}"{{/if}}>{{#if icon}}
		{{{icon}}}
	{{else}}
		<i class="fas"></i>
	{{/if}}{{caption}}</a></li>{{/each}}
	</ul>
</div>

BLOCK;
		$this('admin_index')->html($html)->title('Website Administration');
//		$id = $this->IncludeFile('');
// array(1) { [0]=> array(4) { ["caption"]=> string(16) "User Maintenance" ["href"]=> string(13) "/account/list" ["hint"]=> string(21) "Create and Edit Users" ["s"]=> int(0) } } 
	}
	
	function render_login() {
		$html = <<<BLOCK
<p>Please log in using one of the Authentication Providers listed below</p>
<ul class="email-list list-provider">{{#each provider}}
  <li><a href="{{link}}">{{{value}}}</a></li>
{{/each}}</ul>

BLOCK;
		$this('login_view')->html($html)->title('member login');
//		$id = $this->IncludeFile('');
		
	}
	
	function admin_handlebars() {
		// this will be a list of all changed templates 
		// all the templates will be included in the header
		$html = <<<BLOCK
<div class="indented">
	<h3 class="templateheader">{{page_title}}</h3>
	<p>Rebuilding the handlebars templates...</p>
	<pre>
	{{#each changed}}
<span class="bind-progress-hb" data-name="{{name}}" data-hash="{{md5}}" data-auth="{{auth}}">{{name}}</span>

	{{/each}}
	</pre>
	<p>Rebuild is complete. Back</p>
</div>

BLOCK;
		$this('admin_handlebars')->html($html)->title('Rebuild Handlebars Templates');
		// javascript will go through each: update text "processing..." compile, upload, complete
		// show comple message/link at end
	}
	
}