<?php

// some misc static functions

class Misc {
	
	static
    public function uuid4() {
        $seed = openssl_random_pseudo_bytes(16);

        $seed[6] = chr(ord($seed[6]) & 0x0f | 0x40); // set version to 0100
        $seed[8] = chr(ord($seed[8]) & 0x3f | 0x80); // set bits 6-7 to 10

        return vsprintf('%s%s-%s-%s-%s-%s%s%s', str_split(bin2hex($seed), 4));
    }

	static
	public function GetStatelist() {
		return [
			'AL' => 'Alabama',
			'AK' => 'Alaska',
			'AZ' => 'Arizona',
			'AR' => 'Arkansas',
			'CA' => 'California',
			'CO' => 'Colorado',
			'CT' => 'Connecticut',
			'DE' => 'Delaware',
			'DC' => 'District of Columbia',
			'FL' => 'Florida',
			'GA' => 'Georgia',
			'HI' => 'Hawaii',
			'ID' => 'Idaho',
			'IL' => 'Illinois',
			'IN' => 'Indiana',
			'IA' => 'Iowa',
			'KS' => 'Kansas',
			'KY' => 'Kentucky',
			'LA' => 'Louisiana',
			'ME' => 'Maine',
			'MD' => 'Maryland',
			'MA' => 'Massachusetts',
			'MI' => 'Michigan',
			'MN' => 'Minnesota',
			'MS' => 'Mississippi',
			'MO' => 'Missouri',
			'MT' => 'Montana',
			'NE' => 'Nebraska',
			'NV' => 'Nevada',
			'NH' => 'New Hampshire',
			'NJ' => 'New Jersey',
			'NM' => 'New Mexico',
			'NY' => 'New York',
			'NC' => 'North Carolina',
			'ND' => 'North Dakota',
			'OH' => 'Ohio',
			'OK' => 'Oklahoma',
			'OR' => 'Oregon',
			'PA' => 'Pennsylvania',
			'RI' => 'Rhode Island',
			'SC' => 'South Carolina',
			'SD' => 'South Dakota',
			'TN' => 'Tennessee',
			'TX' => 'Texas',
			'UT' => 'Utah',
			'VT' => 'Vermont',
			'VA' => 'Virginia',
			'WA' => 'Washington',
			'WV' => 'West Virginia',
			'WI' => 'Wisconsin',
			'WY' => 'Wyoming'
		];
	}

	static
	public function ZipToState_US($zip) {
		while(strlen($zip) < 5) {
			$zip = '0' . $zip;
		}
		$ac = intval(substr($zip, 0, 3), 10);
		if ($ac < 100) {
			if ($ac < 5) return '';
			if ($ac == 5) return 'NY';
			if ($ac <= 7) return 'PR';
			if ($ac == 8) return 'VI';
			if ($ac == 9) return 'PR';
			if ($ac <= 27) return 'MA';
			if ($ac <= 29) return 'RI';
			if ($ac <= 38) return 'NH';
			if ($ac <= 49) return 'ME';
			if ($ac == 55) return 'MA';
			if ($ac <= 59) return 'VT';
			if ($ac <= 69) return 'CT';
			if ($ac <= 89) return 'NJ';
			return 'AE';	// Armed Forces Europe*
		} elseif ($ac < 200) {
			if ($ac <= 149) return 'NY';
			if ($ac <= 196) return 'PA';
			if ($ac <= 199) return 'DE';
		} elseif ($ac < 300) {
			if ($ac == 213 || $ac == 269) return '';
			if ($ac == 200) return 'DC';
			if ($ac == 201) return 'VA';
			if ($ac <= 205) return 'DC';
			if ($ac <= 219) return 'MD';
			if ($ac <= 246) return 'VA';
			if ($ac <= 268) return 'WV';
			if ($ac <= 289) return 'NC';
			return 'SC';
		} elseif ($ac < 400) {
			if ($ac == 343 || $ac == 345 || $ac == 348 || $ac == 353) return '';
			if ($ac == 340) return 'AA';	// Armed Forces Americas
			if ($ac <= 319) return 'GA';
			if ($ac <= 349) return 'FL';
			if ($ac <= 369) return 'AL';
			if ($ac <= 385) return 'TN';
			if ($ac <= 397) return 'MS';
			return 'GA';
		} elseif ($ac < 500) {
			if ($ac == 471) return 'KY';
			if ($ac == 428 || $ac == 429) return '';
			if ($ac <= 427) return 'KY';
			if ($ac <= 459) return 'OH';
			if ($ac <= 479) return 'IN';
			if ($ac <= 499) return 'MI';
		} elseif ($ac < 600) {
			if ($ac <= 528) return 'IA';
			if ($ac == 529 || $ac == 533 || $ac == 536 || $ac == 552|| $ac == 589) return '';
			if ($ac <= 549) return 'WI';
			if ($ac <= 566) return 'MN';
			if ($ac == 567) return 'ND';
			if ($ac <= 577) return 'SD';
			if ($ac <= 579) return '';
			if ($ac <= 588) return 'ND';
			return 'MT';
		} elseif ($ac < 700) {
			if ($ac == 621 || $ac == 632 || $ac == 663 || $ac == 682) return '';
			if ($ac <= 629) return 'IL';
			if ($ac <= 641) return 'MO';
			if ($ac < 644) return '';
			if ($ac <= 658) return 'MO';
			if ($ac <= 679) return 'KA';
			if ($ac <= 693) return 'NE';
			return '';
		} elseif ($ac < 800) {
			if ($ac == 702 || $ac == 709 || $ac == 715 || $ac == 732 || $ac == 742) return '';
			if ($ac == 731) return 'TX';
			if ($ac <= 714) return 'LA';
			if ($ac <= 729) return 'AR';
			if ($ac <= 749) return 'OK';
			return 'TX';
		} elseif ($ac < 900) {
			if ($ac == 839 || $ac == 851 || $ac == 854 || $ac == 858 || $ac == 876 || $ac == 892 || $ac == 896 || $ac == 899) return '';
			if ($ac <= 816) return 'CO';
			if ($ac < 820) return '';
			if ($ac <= 831) return 'WY';
			if ($ac <= 838) return 'ID';
			if ($ac <= 847) return 'UT';
			if ($ac < 850) return '';
			if ($ac <= 860) return 'AZ';
			if ($ac < 863) return '';
			if ($ac <= 865) return 'AZ';
			if ($ac < 870) return '';
			if ($ac <= 884) return 'NM';
			if ($ac == 885) return 'TX';
			if ($ac < 889) return '';
			return 'NE';
		} else {
			if ($ac == 909 || $ac == 929 || $ac == 987) return '';
			if ($ac <= 961) return 'CA';
			if ($ac <= 966) return 'AP';	// Armed Forces Pacific
			if ($ac <= 968) return 'HI';
			if ($ac == 969) return 'GU';
			if ($ac <= 979) return 'OR';
			if ($ac <= 994) return 'WA';
			return 'AK';
		}
	}

	static
	public function ZipToState_CA($zip) {
		static $provinces = [
			'A' => 'NL',
			'B' => 'NS',
			'C' => 'PE',
			'E' => 'NB',
			'G' => 'QC',
			'H' => 'QC',
			'J' => 'QC',
			'K' => 'ON',
			'L' => 'ON',
			'M' => 'ON',
			'N' => 'ON',
			'P' => 'ON',
			'R' => 'MB',
			'S' => 'SK',
			'T' => 'AB',
			'V' => 'BC',
			'X' => 'NT',
			'Y' => 'YT',
		];
		$postal_letter = $zip[0];
		if (isset($provinces[$postal_letter])) return $provinces[$postal_letter];
		return '';
    }
	
	static 
	public function ZipToState($zip) {
		$zip = trim(strtoupper($zip));
		if ($zip == '') {
			return [ '', '' ]; 
		} elseif (is_numeric($zip[0])) {
			return [ static::ZipToState_US($zip), 'US' ]; 
		} else {
			return [ static::ZipToState_CA($zip), 'CA' ]; 
		}
	}

	static
	public function TaxableShipping($state) {
		switch($state) {
			case 'AL':
			case 'AK':
			case 'AZ':
			case 'CA':
			case 'CO':
			case 'DC':
			case 'FL':
			case 'IL':
			case 'IA':
			case 'ID':
			case 'LA':
			case 'ME':
			case 'MD':
			case 'MA':
			case 'NV':
			case 'MO':
			case 'OK':
			case 'UT':
			case 'VA':
			case 'WY':
			case '':
				return FALSE;
		}
		return TRUE;
	}

	// from wordpress
	static
	public function remove_accents($string) {
		if ( !preg_match('/[\x80-\xff]/', $string) )
			return $string;

		$chars = array(
		// Decompositions for Latin-1 Supplement
			chr(195).chr(128) => 'A', chr(195).chr(129) => 'A',
			chr(195).chr(130) => 'A', chr(195).chr(131) => 'A',
			chr(195).chr(132) => 'A', chr(195).chr(133) => 'A',
			chr(195).chr(134) => 'AE',chr(195).chr(166) => 'ae', 
			chr(195).chr(135) => 'C', chr(195).chr(136) => 'E',
			chr(195).chr(137) => 'E', chr(195).chr(138) => 'E',
			chr(195).chr(139) => 'E', chr(195).chr(140) => 'I',
			chr(195).chr(141) => 'I', chr(195).chr(142) => 'I',
			chr(195).chr(143) => 'I', chr(195).chr(145) => 'N',
			chr(195).chr(146) => 'O', chr(195).chr(147) => 'O',
			chr(195).chr(148) => 'O', chr(195).chr(149) => 'O',
			chr(195).chr(150) => 'O', chr(195).chr(153) => 'U',
			chr(195).chr(154) => 'U', chr(195).chr(155) => 'U',
			chr(195).chr(156) => 'U', chr(195).chr(157) => 'Y',
			chr(195).chr(159) => 's', chr(195).chr(160) => 'a',
			chr(195).chr(161) => 'a', chr(195).chr(162) => 'a',
			chr(195).chr(163) => 'a', chr(195).chr(164) => 'a',
			chr(195).chr(165) => 'a', chr(195).chr(167) => 'c',
			chr(195).chr(168) => 'e', chr(195).chr(169) => 'e',
			chr(195).chr(170) => 'e', chr(195).chr(171) => 'e',
			chr(195).chr(172) => 'i', chr(195).chr(173) => 'i',
			chr(195).chr(174) => 'i', chr(195).chr(175) => 'i',
			chr(195).chr(177) => 'n', chr(195).chr(178) => 'o',
			chr(195).chr(179) => 'o', chr(195).chr(180) => 'o',
			chr(195).chr(181) => 'o', chr(195).chr(182) => 'o',
			chr(195).chr(182) => 'o', chr(195).chr(185) => 'u',
			chr(195).chr(186) => 'u', chr(195).chr(187) => 'u',
			chr(195).chr(188) => 'u', chr(195).chr(189) => 'y',
			chr(195).chr(191) => 'y',
			// Decompositions for Latin Extended-A
			chr(196).chr(128) => 'A', chr(196).chr(129) => 'a',
			chr(196).chr(130) => 'A', chr(196).chr(131) => 'a',
			chr(196).chr(132) => 'A', chr(196).chr(133) => 'a',
			chr(196).chr(134) => 'C', chr(196).chr(135) => 'c',
			chr(196).chr(136) => 'C', chr(196).chr(137) => 'c',
			chr(196).chr(138) => 'C', chr(196).chr(139) => 'c',
			chr(196).chr(140) => 'C', chr(196).chr(141) => 'c',
			chr(196).chr(142) => 'D', chr(196).chr(143) => 'd',
			chr(196).chr(144) => 'D', chr(196).chr(145) => 'd',
			chr(196).chr(146) => 'E', chr(196).chr(147) => 'e',
			chr(196).chr(148) => 'E', chr(196).chr(149) => 'e',
			chr(196).chr(150) => 'E', chr(196).chr(151) => 'e',
			chr(196).chr(152) => 'E', chr(196).chr(153) => 'e',
			chr(196).chr(154) => 'E', chr(196).chr(155) => 'e',
			chr(196).chr(156) => 'G', chr(196).chr(157) => 'g',
			chr(196).chr(158) => 'G', chr(196).chr(159) => 'g',
			chr(196).chr(160) => 'G', chr(196).chr(161) => 'g',
			chr(196).chr(162) => 'G', chr(196).chr(163) => 'g',
			chr(196).chr(164) => 'H', chr(196).chr(165) => 'h',
			chr(196).chr(166) => 'H', chr(196).chr(167) => 'h',
			chr(196).chr(168) => 'I', chr(196).chr(169) => 'i',
			chr(196).chr(170) => 'I', chr(196).chr(171) => 'i',
			chr(196).chr(172) => 'I', chr(196).chr(173) => 'i',
			chr(196).chr(174) => 'I', chr(196).chr(175) => 'i',
			chr(196).chr(176) => 'I', chr(196).chr(177) => 'i',
			chr(196).chr(178) => 'IJ',chr(196).chr(179) => 'ij',
			chr(196).chr(180) => 'J', chr(196).chr(181) => 'j',
			chr(196).chr(182) => 'K', chr(196).chr(183) => 'k',
			chr(196).chr(184) => 'k', chr(196).chr(185) => 'L',
			chr(196).chr(186) => 'l', chr(196).chr(187) => 'L',
			chr(196).chr(188) => 'l', chr(196).chr(189) => 'L',
			chr(196).chr(190) => 'l', chr(196).chr(191) => 'L',
			chr(197).chr(128) => 'l', chr(197).chr(129) => 'L',
			chr(197).chr(130) => 'l', chr(197).chr(131) => 'N',
			chr(197).chr(132) => 'n', chr(197).chr(133) => 'N',
			chr(197).chr(134) => 'n', chr(197).chr(135) => 'N',
			chr(197).chr(136) => 'n', chr(197).chr(137) => 'N',
			chr(197).chr(138) => 'n', chr(197).chr(139) => 'N',
			chr(197).chr(140) => 'O', chr(197).chr(141) => 'o',
			chr(197).chr(142) => 'O', chr(197).chr(143) => 'o',
			chr(197).chr(144) => 'O', chr(197).chr(145) => 'o',
			chr(197).chr(146) => 'OE',chr(197).chr(147) => 'oe',
			chr(197).chr(148) => 'R',chr(197).chr(149) => 'r',
			chr(197).chr(150) => 'R',chr(197).chr(151) => 'r',
			chr(197).chr(152) => 'R',chr(197).chr(153) => 'r',
			chr(197).chr(154) => 'S',chr(197).chr(155) => 's',
			chr(197).chr(156) => 'S',chr(197).chr(157) => 's',
			chr(197).chr(158) => 'S',chr(197).chr(159) => 's',
			chr(197).chr(160) => 'S', chr(197).chr(161) => 's',
			chr(197).chr(162) => 'T', chr(197).chr(163) => 't',
			chr(197).chr(164) => 'T', chr(197).chr(165) => 't',
			chr(197).chr(166) => 'T', chr(197).chr(167) => 't',
			chr(197).chr(168) => 'U', chr(197).chr(169) => 'u',
			chr(197).chr(170) => 'U', chr(197).chr(171) => 'u',
			chr(197).chr(172) => 'U', chr(197).chr(173) => 'u',
			chr(197).chr(174) => 'U', chr(197).chr(175) => 'u',
			chr(197).chr(176) => 'U', chr(197).chr(177) => 'u',
			chr(197).chr(178) => 'U', chr(197).chr(179) => 'u',
			chr(197).chr(180) => 'W', chr(197).chr(181) => 'w',
			chr(197).chr(182) => 'Y', chr(197).chr(183) => 'y',
			chr(197).chr(184) => 'Y', chr(197).chr(185) => 'Z',
			chr(197).chr(186) => 'z', chr(197).chr(187) => 'Z',
			chr(197).chr(188) => 'z', chr(197).chr(189) => 'Z',
			chr(197).chr(190) => 'z', chr(197).chr(191) => 's'
		);

		$string = strtr($string, $chars);

		return $string;
	}


	static
	public function AsSlug($text) {
		$text = strtolower(static::remove_accents(trim($text)));
		$text = trim(preg_replace('/[^[:alnum:][:space:]]/u', ' ', $text));
		return preg_replace('~\s+~', '-', $text);
	}
	
}