<?php

class Model {

	use \modules\config\traits {
			\modules\config\traits::__construct as __ConstructConfig;
		}

	protected $logging = FALSE;
//	protected $logging = '/phil/logging.txt';
    protected $lp = FALSE;
	public $controller;

	public function __construct() {
		$this->__ConstructConfig();
	}

	static 
	public function GetHandle() {
		$name = static::class;
		if (!isset($GLOBALS['handle'][$name])) {
			return $GLOBALS['handle'][$name] = new static;
		} else {
			return $GLOBALS['handle'][$name];
		}
	}
	public function LogFilename() {
		if (func_num_args()) {
			$this->logging = func_get_arg(0);
			return $this;
		}
		return $this->logging;
	}

	public function Log($message) {
		if ($this->logging !== FALSE) {
			if ($this->lp === FALSE) $this->lp = fopen($this->logging, 'a');
			$dt = date('Y-m-d H:i:s');
			if (is_resource($this->lp)) {
				fwrite($this->lp, "$dt: {$message}\n");
			}
		}
	}

}

class Database_model extends Model {
	
	use \modules\database\traits {
		\modules\database\traits::__construct as __ConstructDatabase;
	}


	public function __construct() {
		parent::__construct();
		$this->__ConstructDatabase();
	}
	
	public function debug() {
		$res = call_user_func_array([$this->_database_engine, 'debug'], func_get_args());
		return func_num_args() > 0 ? $this : $res;
	}
	
	/* public function InheritTable(&$tablename, &$keyfields) {
		if (isset($this->tablename)) {
			$tablename = $this->tablename;
		} else {
			$tablename = FALSE;
		}
		if (isset($this->keyfields)) {
			$keyfields = $this->keyfields;
		} else {
			$keyfields = [];
		}
	} */

}