<?php

namespace modules\pkpCore;

class module_info extends \module {

	function __info() {  
		return [
			'version' => '2026.2.1',
			'required' => TRUE,
			'class' => 'modules\\pkpCore\\main',
			'name' => 'The core PKP framework',
			'depends' => ['input', 'config', 'database', 'cms', 'output', 'composer', 'errorHandler'],
            'composer' => [
                'pelago/emogrifier' => '^6.0',
            ],
			'settings' => [
				[
					'name' => 'theme',
					'caption' => 'Active Theme',
					'type' => 'select',
					'filter' => 'filter.themes',
				],[
					'name' => 'allownew',
					'caption' => 'Allow New Users?',
					'type' => 'select',
					'options' => [
						'0' => 'No',
						'1' => 'Yes',
					],
					'default' => '1',
				], [
					'name' => 'automated_sender',
					'caption' => 'Automated Sender',
					'type' => 'string',
					'default' => 'do-not-reply@example.com',
					'hint'	=> 'Sender Email Address to be used with automated emails. Reply-To address is in System Settings',
				],
			],
			'profile' => [		// domain-specific settings
				[
					'name' => 'activeTheme',
					'caption' => 'Active Theme',
					'type' => 'select',
					'filter' => 'filter.themes',
				]
			],
			'database' =>  [
				'users' => [
					'engine' => 'auto',
					'charset' => 'utf-8',
					'fields' => [
						[ 
							'name' => 'user_id',
							'type' => 'int',
							'size' => 11,
							'null' => FALSE,
							'autoinc' => TRUE,
						],[
							'name' => 'parent_id',
							'type' => 'int',				// parent user account
							'size' => 11,
							'null' => FALSE,
							'default' => 0,
						],[
							'name' => 'level',
							'type' => 'int',
							'size' => 11,
							'default' => 0,					// 11 = setup, 10 = admin, 9 = staff, 1 = registered, 0 = anonymous guest, -1 = disabled
							'null' => TRUE,
						],[
							'name' => 'name_first',
							'type' => 'string',
							'size' => 1024,
							'encrypted' => TRUE
						],[
							'name' => 'name_last',
							'type' => 'string',
							'size' => 1024,
							'encrypted' => TRUE
						],[
							'name' => 'primary_email',
							'type' => 'string',		// used for notificatios, not for login.
							'size' => 512,
							'null' => TRUE,
						],[
							'name' => 'is_locked',
							'type' => 'boolean',
							'default' => 0,
							'null' => FALSE,
						],[
							'name' => 'created',
							'type' => 'int',
							'size' => 11,
							'unsigned' => TRUE,
							'null' => TRUE,
						],
						// date created, date last logged in?
					],
					'index' => [
						'PRIMARY' => [	'type' => 'primary',
										'fields' => ['user_id'],
									],
						'byLevel' => [	'type' => 'index',
										'fields' => ['level'],
									],
						],
					],
				'config' => [
					'engine' => 'auto',
					'charset' => 'utf-8',
					'fields' => [
						[ 
							'name' => 'cfg_hash',
							'type' => 'string',
							'size' => 64,
							'null' => FALSE,
						],[
							'name' => 'cfg_text',
							'type' => 'object',
							'null' => TRUE,
						]
					],
					'index' => [
						'PRIMARY' => [	'type' => 'primary',
									'fields' => ['cfg_hash'],
									],
					]
				],
// TO DO:  include gender?  Active flag?
				'users_source' => [
					'engine' => 'auto',
					'charset' => 'utf-8',
					'comment' => 'authentication source for users',
					'fields' => [
						[ 
							'name' => 'us_source',
							'type' => 'string',
							'size' => 16,
							'null' => FALSE,
						],[
							'name' => 'us_hash',
							'type' => 'string',					// hash(us_identifier)
							'size' => 64,
							'null' => FALSE,
						],[
							'name' => 'us_identifier',
							'type' => 'string',					// user identifier returned from authentication source
							'size' => 1024,
							'encrypted' => TRUE
						],[
							'name' => 'us_user_id',
							'type' => 'int',					// user associated with this login source/method
							'size' => 11,
							'null' => FALSE,
						],[
							'name' => 'password_hash',
							'type' => 'string',					// some will not have passwords
							'size' => 256,
							'null' => TRUE,
						],[
							'name' => 'verified',
							'type' => 'int',
							'size' => 11,
							'default' => 0,
							'null' => TRUE,
						],[
							'name' => 'email',
							'type' => 'string',
							'size' => 1024,
							'encrypted' => TRUE,
							'null' => FALSE,
						],[
							'name' => 'email_hash',
							'type' => 'string',
							'size' => 64,
							'null' => FALSE,
						],[
							'name' => 'forgotten_hash',
							'type' => 'string',
							'size' => 64,
							'null' => TRUE,
						],[
							'name' => 'picture',
							'type' => 'string',		// url
							'size' => 2048,
							'null' => TRUE,
						],[
							'name' => 'name_first',
							'type' => 'string',
							'size' => 1024,
							'encrypted' => TRUE,
							'null' => TRUE,
						],[
							'name' => 'name_last',
							'type' => 'string',
							'size' => 1024,
							'encrypted' => TRUE,
							'null' => TRUE,
						],
					],
					'index' => ['PRIMARY' => [	'type' => 'primary',
												'fields' => ['us_source', 'us_hash'],
											],
								'byEmail' => [	'type' => 'index',
												'fields' => ['email_hash'],
											],
								'byForgot' => [	'type' => 'index',
												'fields' => ['forgotten_hash'],
											]
					]
				]
			],
		];
	}
	
}

// if special file missing, rebuild controller/entrypoint file... add manual overridess

/*
	var $MENUS = [	'menu1' => 'Top Menu',
					'menu2' => 'Footer Widgets',
					'menu3' => 'Footer Line',
					'menu4' => 'Mobile Menu' ];

	const MENUFLAG			 = 0;
	const MENUFLAG_SEPARATOR = 1;		// menu item is a menu separator  (not currently implemented)
	const MENUFLAG_OVERRIDE  = 2;		// menu caption has been overridden from the default
	const MENUFLAG_PUBLIC    = 4;		// is a public function in a controller  (as opposed to a CMS page)
	const MENUFLAG_CUSTOM    = 8;		// custom item (text, email, phonenumber, etc) from the database
	
	public function LoadMenus($dynamic, $static = NULL) {
		global $FRAMEWORK_VAR;
		$pagelist = $dynamic;
		$sep = ['c' => 'Home', 'l' => '/', 's' => self::MENUFLAG_OVERRIDE];
		array_unshift($pagelist, $sep);
//		$sep = ['c' => '----------', 'l' => FALSE, 's' => self::MENUFLAG_SEPARATOR];
//		array_unshift($pagelist, $sep);
//		$pagelist[] = $sep;

		//	add static pages in alpha order to pagelist
		if (is_array($static)) {
			$pagelist = array_merge($pagelist, $static);
		}
		// add special "links" - email address, copyright, etc
		$this->_AppendCustomMenus($pagelist);

		$result = ['source' => $pagelist];

		// add current menu items
		foreach($this->MENUS as $name => $caption) {
			if (isset($FRAMEWORK_VAR->CONFIG['menus'][$name])) {
				$items = $FRAMEWORK_VAR->CONFIG['menus'][$name];
				$this->_AddDynamicContent($items);
			} else {
				$items = [];
			}
			$result[$name] = ['caption' => $caption, 'items' => $items];
		}
		return $result;
	}
	
	private function _AppendCustomMenus(&$pagelist) {
		$sql = 'select mc_id,mc_caption from menu_custom order by mc_id desc';
		$data = $this->Query($sql, NULL, NULL);
		foreach($data as $data_item) {
			$pagelist[] = [	'c' => $data_item['mc_caption'], 
							'v' => $this->AsVisible($data_item['mc_caption'], FALSE),
							// 'l' => '', 		// these do not have links (links calcuated later, based on caption text)
							's' => self::MENUFLAG_OVERRIDE | self::MENUFLAG_CUSTOM, 
							'id' => $data_item['mc_id'] ];
		}
	}
	
	public function SaveMenus($post) {
		global $FRAMEWORK_VAR;
		$FRAMEWORK_VAR->CONFIG['menus'] = $post;
		$FRAMEWORK_VAR->SaveConfig();		// update /core/.htconfig file
	}
	
	public function RetrieveMenu($menu_id) {
		global $config, $FRAMEWORK_VAR;
		$output = [];
		$c = isset($FRAMEWORK_VAR->CONFIG['menus'][$menu_id]) ? count($FRAMEWORK_VAR->CONFIG['menus'][$menu_id]) : 0;
		if ($c) {
			$menuitems = $FRAMEWORK_VAR->CONFIG['menus'][$menu_id];
			$position = 0;
			$this->ProcessMenu($output, $menuitems, $position, $c);
		}
/*		echo "menueditmodel: HookDump:\n";
		var_dump($config->TraceHooks());
		echo "---------\n";  * /
		$output = $FRAMEWORK_VAR->ExecuteHook('menu.retrieve', $output, $menu_id);
		return $output;
	}
	
	private function ProcessMenu(&$output, $menuitems, &$position, $c) {
		$indent = $menuitems[$position]['i'];
		while ($position < $c && $menuitems[$position]['i'] == $indent) {
			$x = $menuitems[$position];
			$menuflags = intval($x['s']);
			$node = ['class' => '', 'href' => $x['l'], 'caption' => $x['c'], 's' => $menuflags ];
			$position++;
			if ($position < $c && $menuitems[$position]['i'] > $indent) {
				$node['menu'] = [];
				$this->processMenu($node['menu'], $menuitems, $position, $c);
			}
			if (!($menuflags & self::MENUFLAG_SEPARATOR)) $output[] = $node;
			if ($position < $c && $menuitems[$position]['i'] < $indent) break;
		}
	}

	*/