<?php
	
class pkpCore_admin extends Controller {
	
	public function __construct() {
		parent::__construct(dirname(__DIR__));
//        $this->IncludeFile('/static/admin.css');      // now handled by module.js
//        $this->IncludeFile('/static/admin.js');
	}

/*	public function __call($name, $arguments) {
		if (preg_match('/^[0-9a-fA-F]{8}$/', $name)) {
			array_unshift($arguments, 'testoption');
			return $arguments;
		} else {
			return FALSE;		// not compatible
		}
	} */
	
	public function __Register() {
		$this->RegisterView(__CLASS__ .'::index', ['admin_view' => ['render_index']]);
		$this->RegisterView(__CLASS__ .'::rebuild_handlebars', ['admin_view' => ['admin_handlebars']]);
	}
	
	// if everyone, then parts of admin.css need to be included here
	/** staff */
	public function index() {
		$res = $this->DefaultResult(__METHOD__);
		$items = hook_execute('menu.admin', []);
		$res['items'] = $items;
		$res['template'] = 'admin_index';		// uses 'menu.admin' hook
		// media library
		// menu editor
		return $res;
	}
	
	/** staff */
	public function rebuild_handlebars() {
		$essential = intval($this->param('essential', '0'));
		$model = $this->LoadModel('handlebars_model');
		// the basic compiled template should be included with the distribution package
		$res = $this->DefaultResult(__METHOD__);
		// get all changed items
		$res['changed'] = $model->Enumerate($essential);
		$res['template'] = 'admin_handlebars';
		if (count($res['changed'])) {
			$res['execute'] = 'rebuildHandlebars';
		}
		return $res;
	}

}