<?php

class Controller extends ModuleMain {

	use \modules\input\traits {
			\modules\input\traits::__construct as __ConstructInput;
		}
	use \modules\config\traits {
			\modules\config\traits::__construct as __ConstructConfig;
		}
	use \modules\output\traits {
			\modules\output\traits::__construct as __ConstructOutput;
		}
		
	private $module_config = NULL;
	public $isPost;
	public $PHASE;

	public function __construct($module_dir = '') {
		parent::__construct($module_dir);
		$this->__ConstructInput();
		$this->__ConstructConfig();
		$this->__ConstructOutput();
		$this->isPost = $this->method() == 'POST';
		$this->PHASE = 0;
		//$this->module_dir = $module_dir;

//		$this->debug = $GLOBALS['config']->GetClientIP() == '71.174.191.227';
	}

	static 
	public function GetHandle() {
		$name = static::class;
		if (!isset($GLOBALS['handle'][$name])) {
			return $GLOBALS['handle'][$name] = new static;
		} else {
			return $GLOBALS['handle'][$name];
		}
	}

	protected function OutputArray($data) {
		global $config;
		$contenttype = $config->getPreferredDocumentType();
		$view = $this->LoadView('Export_json');

		if (!empty($data['result']) && empty($data['message'])) $data['message'] = $config->ErrorMessage($data['result']);

		$is_json = strpos($contenttype, 'json') !== FALSE;
		if ($is_json) {
			return $view->render($data);
		} elseif (empty($data['template']) && empty($data['popup']) && !empty($data['result'])) {
			$this->Error($data['result'], $data['message']);
		} else {
			return $view->render($data);
		}
	}

	protected function Error($error_num, $message = NULL) {
		global $config;
		$classname = $config->error_controller;
		$path = GetControllerPath($classname);
		require_once $path;
		$obj2 = new $classname;
		
		$result = call_user_func_array(array($obj2, 'displayerror'), array($error_num, $message));
		if (isset($result) && is_array($result)) {
			$result = $obj->OutputArray($result);
		}
		die($result);
	}
}
