<?php

	require_once __DIR__ . '/lessc.inc.php';
	
Class Output_Model extends Model {
	
	private function isStaticFile($segments) {
		array_shift($segments);
		$module = array_shift($segments);
		$path = join('/', $segments);
		if ($path == '') return '';
		$filename = HOME . '/modules/' . $module . '/static/' . $path;
		$filename = str_replace(['..', '&', '<', '>', '|'], '', $filename) . '.less';
		return file_exists($filename) ? $filename : '';
	}
	
	
	public function ConvertLESStoCSS($param) {
		if ($param[0] == '~') {
			$path = $this->isStaticFile($param);
		} else {
			$path = join('/', $param);
			$path = str_replace(['..', '\\', ';', '<', '>', '&'], '', $path);
			$path = HOME . '/public/'. $path . '.less';
		}
		if (file_exists($path)) {
			$x = new lessc;
			$output = $x->compile(file_get_contents($path));
			header('Content-type: text/css');
			return $output;
		} else {
			header('Content-type: text/plain');
			die('Not found - ' . $path);
		}
	}

}