<?php

class Login_View extends View {

// https://dxr.mozilla.org/firefox/source/toolkit/components/passwordmgr/src/nsLoginManager.js
	function _addSaveForm($formname, $href) {
		$id = $this->IncludeFile('');
		$javascript = <<<'BLOCK'
function email_login(id) {
	var $form = $(id);
	var data = $form.serialize();
	var action = $form.attr('href') || '';
	if (action == '') action = document.location.href;
	
	$.ajax({
		dataType: 'json',
		data: data,
		async: true,
		url: action,
		type: 'POST',
		crossDomain: true,
	}).done(function(data) {
		if (!data.result || data.result == -9999) {		// if success, close popupform
			try {
				var $dialog = $('div.popup-dialog').first();
				$dialog.dialog('close');
			} catch(e) {
			}
		}
		if (typeof data.redirect != 'undefined') {
			window.location.href = data.redirect;
		} else {
			main.displayPage(data);
		}
	});
}

BLOCK;

		// this allows both json request, and save password in browser password manager
		$id->JavascriptCommand($javascript, FALSE)->depends('jquery');
		return "id=\"$formname\" action=\"javascript:email_login('#$formname');\" href=\"$href\"";
	}

	function render_login() {
		hook_execute('component.add', FALSE, 'password');
		$macro = hook_execute('component.add', '', 'formedit');	
		$button = hook_execute_late('html.button', '', 'Login', 'fas fa-sign-in-alt', 'cc-blue');
		
		$formparam = $this->_addSaveForm('login_form', '/~/loginEmail/login');
		// <form method="post" action="/~/loginEmail/login" class="frm json">
		$html = <<<BLOCK
<div class="main-body">
	<div class="column main-column">
		<div class="container">
			<span class="login-prompt">
				<form class="frm" accept-charset="UTF-8" autocomplete="off" method="post" $formparam>
$macro
				<div class="form-options">
					<div class="option-left">
						<a href="/~/loginEmail/forgot-password" rel="nofollow">Forgot Password?</a><br>
						<a href="/~/loginEmail/register" rel="nofollow">Register</a>
					</div>
					<div class="option-right">
						<a class="submit" href="#">$button</a>
					</div>
				</div>
				</form>
			</span>
		</div>
	</div>
	<div class="column main-right">
		<div class="container">
			<ul class="email-list list-provider">{{#each provider}}
			  <li><a href="{{link}}">{{{value}}}</a></li>
			{{/each}}</ul>
		</div>
	</div>
</div>

BLOCK;
		$this('login_view_email')->html($html)->title('member login');
		
// email
// password
// focus email address
// forgot password
// login button
// register link
// invalid username or password noty.
// get LOGOUT working correctly
	}
	
	function render_registration_form() {
		hook_execute('component.add', FALSE, 'password');
		$macro = hook_execute('component.add', '', 'formedit');	
		$button = hook_execute_late('html.button', '', 'Continue', 'fas fa-arrow-circle-right', 'cc-blue');
		$html = <<<BLOCK
	<span style="display: inline-block; width: 400px">
	<form method="post" action="{{postlink}}" autocomplete="off" class="frm json">
$macro
	<div class="form-actions right"><a class="submit" href="#">$button</a>
		<div class="footnote" style="margin-top:10px;font-style:italic;color:#999">All fields are required</div>
	</div>
	</form>
	</span>

BLOCK;
		$this('register_form')->html($html)->macro('register');

	}
	
	function render_registration_page() {
		$html = <<<BLOCK
<div class="indented">
	<h3 class="templateheader">{{page_title}}</h3>
	<p>To create a new account, please enter your details below. You'll need to activate 
	the account by clicking on the link in the confirmation email.</p>
{{> register}}
</div>

BLOCK;
		$this('register_email')->html($html)->title('New User Registration');
	}
	
	function render_verification() {
		$button = hook_execute_late('html.button', '', 'Verify', 'fas fa-arrow-circle-right', 'cc-blue');
		$html = <<<BLOCK
<div class="indented">
	<h3 class="templateheader">{{page_title}}</h3>
	<p>To verify your email address, please enter the 6-digit authentication code we emailed you in the box below,
	or click on the link within the email.</p>
	<p>If you did not receive an email, please check your spam folder. You may <a href="/email-link/{{hash}}/resend" class="ajax">resend</a> the verification email if you wish.</p>
	<form method="post" action="{{postlink}}" autocomplete="off"  class="frm">
	
		<div class="control-group cf-auth required">
		<label for="auth">Authentication Code</label>
		<div class="controls"><input class="required" id="auth" name="auth" size="30" type="text" value="{{auth}}" style="width:100px"></div>
		<div class="status-message" for="auth"></div></div>
	
		<div class="form-actions right"><a class="submit" href="#">$button</a></div>
	</form>
</div>

BLOCK;
		$this('register_verify')->html($html)->title('Please Verify Your Email Address');
	}
    
    public function template_confirmation_email() {
		$body = <<<BLOCK

<p>Welcome to {{company}}; there is one final step - please confirm your email address.</p>

<p>Your authentication code is:</p>
<div style="font-size:48px">{{authcode}}</div>

<p>To confirm your address please <a href="{{link}}">follow this link</a>. Otherwise, if you do not recognize this email, simply delete it.</p>
<p>The link and authentication code expire in 24 hours.</p>

BLOCK;
		return ['title' => 'Confirm Email Address',
				'subject' => 'Confirm Your Email Address',
				'body' => $body];
	}
    
    public function template_forgottenpassword_email() {
		$body = <<<BLOCK

<p>Please choose the appropriate link, depending on what you would like to do:</p>
<ul><li> To log in now: <a href="{{link}}/login">follow this link</a></li>
<li> To change your password: <a href="{{link}}/password">follow this link</a></li></ul>

<p>Only one link can be used, and it can only be used once. Both links expire in 24 hours.</p>

BLOCK;
		return ['title' => 'Forgotten Password Request',
				'subject' => 'Forgotten Password Request',
				'body' => $body];
	}
	
	public function template_forgotten() {
		$macro = hook_execute('component.add', '', 'formedit');	
		$button = hook_execute_late('html.button', '', 'Send Email', 'far fa-envelope', 'cc-blue');
		$html = <<<BLOCK
<form method="post" action="/~/loginEmail/forgot-password" autocomplete="off"  class="frm indented">
	<h3 class="templateheader">{{page_title}}</h3>
	<p>Please enter the email address last used to log in.  If is it recognized, you'll be sent an email with a link you can use.</p>
$macro
	<div class="form-actions right"><a class="submit" href="#">$button</a></div?
</form>

BLOCK;
		$this('register_forgotten')->html($html)->title('Forgotten Password');
        
        $html = <<<BLOCK
<div class="indented">
	<h3 class="templateheader">{{page_title}}</h3>
    <p>If you have entered your correct email address, we have sent you a link you can use to either log in, or change your password.</p>
    <p>If it does not arrive within a few minutes, please check your Spam folder</p>
</div>
BLOCK;
        $this('done_forgotten')->html($html)->title('Forgotten Password');
	}

	// to do: hide password on submit (if visible)
	//  use alternative post to allow display of browser's change-of-password prompt
	// include email as hidden field
    public function template_changepassword() {
		hook_execute('component.add', FALSE, 'password');
		$button = hook_execute_late('html.button', '', 'Update', 'far fa-check-circle', 'cc-blue');
 		$formparam = $this->_addSaveForm('change_password', '/~/loginEmail/change-password');
      $html = <<<BLOCK
<div class="indented">
	<h3 class="templateheader">{{page_title}}</h3>
	<form class="frm" accept-charset="UTF-8" method="post" autocomplete="off"  style="width:400px" $formparam>
		<input type="hidden" name="us_hash" value="{{us_hash}}">
		<input type="text" name="username" value="{{email}}" style="display:none">

		<div class="control-group cf-pass1 required">
		<label for="pass1">New Password</label>
		<div class="controls"><input class="required admin-password" id="pass1" name="password" size="30" type="password" value=""  style="width:300px"></div>
		<div class="status-message" for="pass1"></div></div>

		<div class="control-group cf-pass2 required">
		<label for="pass2">New Password (again)</label>
		<div class="controls"><input class="required admin-password" id="pass2" name="password_verify" size="30" type="password" value="" style="width:300px"></div>
		<div class="status-message" for="pass2"></div></div>
    
        <div class="form-actions right"><a class="hidepass submit" href="#">$button</a></div?
    </form>
</div>
BLOCK;
		$this('register_password')->html($html)->title('Change Password');
    }

}