<?php

namespace modules\loginEmail;

class module_info extends \module {

	function __info() {  
		return [
			'version' => '2026.2.1',
			'required' => FALSE,
			'authentication' => 'email',
			'class' => 'modules\\loginEmail\\main',
			'name' => 'User Authentication - Email Address',
			'theme' => 'loginEmail',
			'depends' => ['input', 'database', 'output'],
			'email' => [	// internal name  => entrypoint
							'confirmation'  => 'modules\\loginEmail\\view\\login_view::template_confirmation_email',
							'forgotten'     => 'modules\\loginEmail\\view\\login_view::template_forgottenpassword_email',
						],
			'database' =>  [
				'users_verification' => [
					'engine' => 'auto',
					'charset' => 'utf-8',
					'comment' => 'User Verification',
					'fields' => [
						[
							'name' => 'uv_user_id',
							'type' => 'int',
							'size' => 11,
							'null' => FALSE,
						],[
							'name' => 'uv_date',
							'type' => 'int',
							'size' => 11,
							'unsigned' => TRUE,
							'null' => FALSE,
						],[
							'name' => 'uv_code',
							'type' => 'string',
							'size' => 20,
							'null' => FALSE,
						],[
							'name' => 'uv_login',       // is this a single-use login link?
							'type' => 'boolean',
							'null' => FALSE,
							'default' => 0,
						],[
							'name' => 'uv_return',		// return URL
							'type' => 'string',
							'size' => 512,
							'default' => '',
							'null' => FALSE,
						],
					],
					'index' => [
						'PRIMARY' => [	'type' => 'primary',
										'fields' => ['uv_user_id', 'uv_code'],
									],
					],
				],
                'users_source' => [
					'engine' => 'auto',
					'charset' => 'utf-8',
                    'fields' => [
                        [ 
                            'name' => 'us_lastpwd',         // json array of last passwords
                            'type' => 'text',
                            'null' => TRUE,
                        ],[
                            'name' => 'us_lastchange',      // date of last password change
                            'type' => 'int',
                            'size' => 11,
                            'unsigned' => TRUE,
                            'null' => TRUE,
                        ],
                    ],
                ],
			],
            
            
		];
	}

}
