<?php

// add handlebars macro
// add text to existing views
// generate $res['fields'] data
// include css and js files

// handle fieldsets, tabs, custom field types
// handle fieldsizes, placeholders, hint, helptext, move cursor to first field


class FormEdit_View extends View {
//{{#macro "fields" fieldlist=""}}		
	
	function handlebars_template() {
		$html = <<<BLOCK
	{{#if helplink}}
		<a class="helpicon" href="{{helplink}}" target="pkp"></a></div>
	{{/if}}
	{{#each fieldlist}}
		{{#ifeq type 'hidden'}}
			<input type="hidden" id="{{id}}" name="{{name}}" value="{{indirect @root name}}">
		{{else}}{{#ifeq type 'comment'}}
				<div>{{{caption}}}</div>
			{{else}}
				<div class="control-group cf-{{id}}{{#if required}} required{{/if}}">
				{{#ifeq type 'string'}}
					<label for="{{id}}">{{caption}}</label>
					<div class="controls"><input class="{{#if required}}required{{/if}} {{class}}"{{#if hint}} title="{{hint}}"{{/if}}{{#if placeholder}} placeholder="{{placeholder}}"{{/if}} id="{{id}}" name="{{name}}" size="30" type="text" value="{{indirect @root name}}"></div>
				{{/ifeq}}{{#ifeq type 'email'}}
					<label for="{{id}}">{{caption}}</label>
					<div class="controls"><input class="{{#if required}}required{{/if}} {{class}}"{{#if hint}} title="{{hint}}"{{/if}}{{#if placeholder}} placeholder="{{placeholder}}"{{/if}} id="{{id}}" name="{{name}}" size="30" type="email" value="{{indirect @root name}}"></div>
				{{/ifeq}}{{#ifeq type 'tel'}}
					<label for="{{id}}">{{caption}}</label>
					<div class="controls"><input class="bind-tel {{#if required}}required{{/if}} {{class}}"{{#if hint}} title="{{hint}}"{{/if}}{{#if placeholder}} placeholder="{{placeholder}}"{{/if}} id="{{id}}" name="{{name}}" size="30" type="text" value="{{indirect @root name}}"></div>
				{{/ifeq}}{{#ifeq type 'select'}}
					<label for="{{id}}">{{caption}}</label>
					<div class="controls"><select id="{{id}}" name="{{name}}"{{#if hint}} title="{{hint}}"{{/if}} class="{{class}}">
						{{#each options}}<option value="{{@key}}"{{select @root ../name @key}}>{{this}}</option>
						{{/each}}</select></div>
				{{/ifeq}}{{#ifeq type 'text'}}
<label for="{{id}}">{{caption}}</label>
<div class="controls">
<textarea id="{{id}}" class="cf-textarea {{class}}" name="{{name}}" type="text"{{#if hint}} title="{{hint}}"{{/if}} wrap="physical">{{indirect @root name}}</textarea></div>
				{{/ifeq}}{{#ifeq type 'int'}}
					<label for="{{id}}">{{caption}}</label>
					<div class="controls"><input class="{{#if required}}required{{/if}} short {{class}}"{{#if hint}} title="{{hint}}"{{/if}} id="{{id}}" name="{{name}}" size="10" type="text" value="{{indirect @root name}}"></div>
				
				{{/ifeq}}{{#ifeq type 'boolean'}}
					<label>&nbsp;</label>
					<div class="controls">
						<div class="control-checkbox"><input type="checkbox" id="{{id}}" class="{{class}}"  value="1"
							name="{{name}}"{{#if hint}} title="{{hint}}"{{/if}}{{#ifindirect @root name}} checked{{/ifindirect}}> 
							<label for="{{id}}">{{caption}}</label>
						</div>
					</div>
				{{/ifeq}}{{#ifeq type 'password'}}
					<label for="{{id}}">{{caption}}</label>
					<div class="controls"><input class="{{#if required}}required {{/if}}admin-password {{class}}"{{#if hint}} title="{{hint}}"{{/if}} id="{{id}}" name="{{name}}" size="30" 
						type="password" value="{{indirect @root name}}"></div>
				{{/ifeq}}{{#ifeq type 'custom'}}
					<label for="{{id}}">{{caption}}</label>
					{{{custom}}}
				{{/ifeq}}
				<div class="status-message" for="{{id}}">{{{status}}}</div></div>
			{{/ifeq}}
		{{/ifeq}}
	{{/each}}

BLOCK;
//{{/macro}}
/*
      <input data-toggle="password"
        data-placement="after"
        class="form-control"
        type="password"
        value="123"
        placeholder="password"
        data-eye-class="material-icons"
        data-eye-open-class="visibility"
        data-eye-close-class="visibility_off"
        data-eye-class-position-inside="true">
*/

		$this('fieldlist_id')->html($html)->macro('fields');

		// {{> cannot have leading whitespace
		$html = <<<BLOCK
{{#if fieldset}}
	{{#each fieldset}}<fieldset style="position: relative">
		<legend>&nbsp;{{name}}&nbsp;</legend>
{{> fields fieldlist=fieldlist}}
		</fieldset>
	{{/each}}
{{else}}
{{> fields fieldlist=fieldlist}}
{{/if}}
BLOCK;
		
		$this('formedit_id')->html($html)->macro('formedit');
	}
	
}