<?php

namespace modules\errorHandler;

// Maintenance Mode error:
// apache2 caches files, so if the work file is missing: you'll need a "service apache2 restart"   ('apachectl restart' wont do it)

class main extends \moduleMain {

		// HTTP Status Codes array
	public function getStatusCodeMessage($status) {
		//HTTP status codes
		$codes = array(
			100 => 'Continue', 
			101 => 'Switching Protocols', 
			200 => 'OK', 
			201 => 'Created', 
			202 => 'Accepted', 
			203 => 'Non-Authoritative Information', 
			204 => 'No Content', 
			205 => 'Reset Content', 
			206 => 'Partial Content', 
			300 => 'Multiple Choices', 
			301 => 'Moved Permanently', 
			302 => 'Found', 
			303 => 'See Other', 
			304 => 'Not Modified', 
			305 => 'Use Proxy', 
			306 => '(Unused)', 
			307 => 'Temporary Redirect', 
			400 => 'Bad Request', 
			401 => 'Unauthorized', 
			402 => 'Payment Required', 
			403 => 'Forbidden', 
			404 => 'Not Found', 
			405 => 'Method Not Allowed', 
			406 => 'Not Acceptable', 
			407 => 'Proxy Authentication Required', 
			408 => 'Request Timeout', 
			409 => 'Conflict', 
			410 => 'Gone', 
			411 => 'Length Required', 
			412 => 'Precondition Failed', 
			413 => 'Request Entity Too Large', 
			414 => 'Request-URI Too Long', 
			415 => 'Unsupported Media Type', 
			416 => 'Requested Range Not Satisfiable', 
			417 => 'Expectation Failed', 
			422 => 'Unprocessable Entity', 
            450 => 'Maintenance Mode',          // our custom error
			500 => 'Internal Server Error', 
			501 => 'Not Implemented', 
			502 => 'Bad Gateway', 
			503 => 'Service Unavailable', 
			504 => 'Gateway Timeout', 
			505 => 'HTTP Version Not Supported'
		);

		return (isset($codes[$status])) ? $codes[$status] : 'Unknown Error';
	}
	
	public function __construct() {
		parent::__construct();
	}
	
	public function Activate() {
		hook_add('output.error', [$this, '__error']);
	}

	// return error json or html
	//  add error message text
	public function __error(&$handled, $http_status, $output ) {
		if ($handled === FALSE)	{
			
			$httpstatus = $http_status->status();
			$message = $http_status->message();
			if ($message == '') $message = $this->getStatusCodeMessage($httpstatus);
			
			$data = [
				'message' => $message,
				'errnum' => $httpstatus,
				'desc' => '',
				'extra' => ''
			];
			switch($httpstatus) {
				case 404: 
					$data['desc'] = "We're sorry, but this page doesn't exist.<br />Please check your URL for mistakes and refresh the page.";
					break;
				case 450: 
					$data['desc'] = "We're sorry, but this website is in Maintenance Mode.<br />Please try again in a few minutes.";
					break;
			}
			$errnum = $http_status->errnum();
			if ($errnum !== FALSE) {
				$data['extra'] .= "<p>Error Code $errnum</p>";
			}
			$note = $http_status->note();
			if ($note != '') $data['desc'] = $note;
			
			$data = hook_execute('output.errordetail', $data, $http_status);
			$res = $output->OutputFormat();
			if ($res == 'html') {	// if html set body, otherwise set data
				$body = <<<BLOCK
<div class="errorContainer">
	<div>
        <h2 class="templateheader">{$data['message']}</h2>
		<h4>OOPS! Something went wrong.</h4>
		<p>{$data['desc']}</p>
		{$data['extra']}
	</div>
</div>
BLOCK;
				$output ->Body($body)
                        ->Title($data['message'])
                        ->ExportHandler(NULL);
			} else {
				$data = [
					'error' => $errnum,
					'message' => $message,
					'body' => $body
				];
				$output->ExportHandler($data);
			}
			$handled = TRUE;
		}
	}
}