<?php

namespace modules\emailPhpMailer;

// is smtp server specified, from cloud.google.com, it cannot use port 25, 465 or 587
//		unless connecting to g-suite mail server

class module_info extends \module {

	function __info() {  
		return [
			'version' => '6.9.3.5',
			'required' => FALSE,
			'class' => 'modules\\emailPhpMailer\\main',
			'name' => 'Send emails using PHP Mailer',
			'depends' => [],
			'settings' => [
				[
					'name' => 'smtp',
					'type' => 'string',
					'caption' => 'SMTP Server',
				],
				[
					'name' => 'user',
					'type' => 'string',
					'caption' => 'SMTP Username',
				],
				[
					'name' => 'pass',
					'type' => 'password',
					'caption' => 'Password',
				],
				[
					'name' => 'port',
					'type' => 'select',
					'caption' => 'SMTP Server Port',
					'options' => [ 
							25 =>  '25 (insecure)',
							465 => '465 (SSL)',
							466 => '466 (SSL, non-standard)',
							587 => '587 (TLS)',
					],
				],
			]
		];
	}
	
}

// tls://smtp1.example.com:587;ssl://smtp2.example.com:465