<?php

namespace modules\datatables;

class main extends \moduleMain {
	
	private $active = FALSE;

	public function __construct() {
		parent::__construct(__DIR__);
	}

	public function Activate() {
		hook_add('component.add', [$this, '__component']);
		hook_add('html.prepare', [$this, '__html_prepare'], 30);
	}
	
	public function __component(&$status, $requested) {
		if ($requested == 'datatables') {
			$this->active = TRUE;
			$status = TRUE;
		}
	}
	
	/* jeditable has been modified from the original:  onBlur function changed:
original:
                } else if ($.isFunction(settings.onblur)) {
                    input.blur(function(e) {
                        settings.onblur.apply(self, [input.val(), settings]);
                    });

new:
                } else if ($.isFunction(settings.onblur)) {
                    input.blur(function(e) {
                        settings.onblur.apply(self, [input.val(), settings, e]);
                    });

line added after "input.attr('autocomplete','off');"
	input.attr('placeholder', $(original).attr('placeholder'));

	
to use in console, select element -> Use in Console :
	$(temp0).trigger('click')
	
	*/
	
	
	public function __html_prepare($modulemain) {
		$base = $modulemain->StaticUriModule(__DIR__);
		$modulemain->IncludeFile("$base/jquery.dataTables.min.css")
				->version('1.10.16');	// css
		$modulemain->IncludeFile("$base/jquery.dataTables.min.js", 'datatables')
				->depends('jquery')
				->version('1.10.16');	// js
		$css = <<<BLOCK
div.dt-buttons {
	float: right;
	padding: 3px;
}
BLOCK;
		
		$modulemain->IncludeFile("$base/buttons.dataTables.min.css")
			->Version('1.5.6')
			->AddCSS($css);
		$modulemain->IncludeFile("$base/dataTables.buttons.min.js")
			->Depends('datatables')
			->Version('1.5.6');
	}

}
