
var $ = jQuery.noConflict();

function ContextMenu() {
	let _this = this;
	let subItems;

	function _getData($target) {
		let $k = $target.closest('li.jstree-node');
		let temp = $k.data('data');
		if (typeof temp != 'undefined') return temp;
		temp = $target[0];
		return temp.id;
	}

	function _attachContextMenu(selector) {
		$.contextMenu({
			selector: selector,
			trigger: 'none',
			reposition: false,
			build: function ($trigger, e) {
				return {
					callback: function (key, options) {
						if (typeof subItems[key] != 'undefined')  {
							if (subItems[key].click) {
								let fn = window[subItems[key].click];
								if (typeof fn == 'function') return fn(subItems[key]);
							} 
							if (subItems[key].href) {
								// do our special ajax to perform the selected popup item
								let className = subItems[key].className || '';
								className = ' ' + className + ' ';
								if (className.indexOf(' json ') > -1) {
									main.loadURL(subItems[key].href);
								} else if (className.indexOf(' ajax ') > -1) {
									history.pushState(null, null, subItems[key].href);
									main.loadURL(subItems[key].href);
								} else {
									window.location.href = subItems[key].href;
								}
							}
						}
					},
					items: subItems,
				};
			}
		});
	}

	_this.loadContextMenus = function ($parent) {
		let $context = $('.contextMenu', $parent);
		if ($context.length) {
			_attachContextMenu('.contextMenu');
		}
	}
	
	function contextClick(e, $context, $target) {
		let ajax = $context.attr('context');
		if (ajax === undefined) {
			let $container = $context.closest('*[context]');
			ajax = $container.attr('context');
		}
		if (ajax !== undefined) {      // only when 'ajax' attr present
			let sep = ajax.indexOf('?') > -1 ? '&' : '?';
			let info = _getData($target);
			if (info != '') {
				ajax += sep + 'src=' + info;
				sep = '&';
			}
			const date = new Date();
			const offsetMinutes = date.getTimezoneOffset();
			ajax += sep + 'ofs=' + offsetMinutes;
			sep = '&';
			// determine position within $context
			let p = $context.offset();
			ajax += sep + 'x=' + (e.pageX - p.left) + '&y=' + (e.pageY - p.top);
			sep = '&';
			
			// attach timezone delta
			_attachContextMenu($context);

			$.getJSON( ajax, function( data ) {
				subItems = data;
				$context.contextMenu({x: e.pageX, y: e.pageY});
			});
			e.preventDefault();
		}
	}

	$(document).on('loaded.template', function() {
		_this.loadContextMenus($(document));

	}).on('mouseup', '.contextMenu', function(e) {
		if (e.which != 3) return;
		let $context = $(this);
		let $target = $(e.target);
		contextClick(e, $context, $target);

	}).on('contextmenu', function(e) {
		let $target = $(e.target);
		let x = $target.closest('.contextMenu');
		if (x.length) {
			return false;	// disable browser context
		}

	}).on('loaded.datatables', function(event, table) {
		_this.loadContextMenus($(table));
		
	}).on('click', '.action-context2', function(e) {
		// left click for the context
		let $context = $(this);
		let $target = $(e.target);
		contextClick(e, $context, $target);
		e.preventDefault();
	});

}

contextmenu = new ContextMenu();
