<?php

namespace modules\contextMenu;

// https://swisnl.github.io/jQuery-contextMenu/demo/async-promise.html
class main extends \moduleMain {

	use \modules\output\traits {
			\modules\output\traits::__construct as __ConstructOutput;
		}

	private $active = FALSE;

	public function __construct() {
		parent::__construct(__DIR__);
		$this->__ConstructOutput();
	}

	public function Activate() {
		hook_add('component.add', [$this, '__component']);
		hook_add('html.prepare', [$this, '__html_prepare']);
	}
	
	public function __component(&$status, $requested) {
		if ($requested == 'contextMenu') {
			$this->active = TRUE;
			$status = TRUE;
		}
	}
	
	public function __html_prepare($modulemain) {
		$ext = $this->getJsExtension();
		$base = $modulemain->StaticUriModule(__DIR__);
		
		$modulemain->IncludeFile($base . '/jquery.contextMenu.min.css');

		$modulemain->IncludeFile($base . '/jquery.ui.position.min.js')
			->library('jquery-ui-position')
			->depends('jquery-ui');

		// use uglify on `rog` to create min.js file
		//  uglifyjs jquery.contextMenu.js --compress -o jquery.contextMenu.min.js
		$modulemain->IncludeFile($base . "/jquery.contextMenu{$ext}", 'contextjs')
			->depends('jquery-ui-position');

		$modulemain->IncludeFile($base . '/contextMenu.js')
			->depends('contextjs');

/* subItems = {
				"edit": { name: "Edit", icon: "edit" },
				"cut": { name: "Cut", icon: "cut" },
				"status": {
					name: "Status",
					icon: "delete",
					items: {
						"sub1": { name: "Submenu1", icon: "edit" },
						"sub2": { name: "Submenu2", icon: "cut" },
					},
				},
				"normalSub": {
					name: "Normal Sub",
					items: {
						"normalsub1": { name: "normal Sub 1"},
						"normalsub2": { name: "normal Sub 2"},
						"normalsub3": { name: "normal Sub 3"},
					}
				}
			}
*/			
	}

}
