<?php

class setup_View extends View {
	
	//  of <strong>{{product_name}}</strong>.
	function render_setup() {
		$button = hook_execute_late('html.button', '', 'Continue', 'far fa-check-circle', 'cc-blue');
		$html = <<<BLOCK
<form method="post" class="indented frm">
	<h3 class="templateheader">{{page_title}}</h3>
	<p>Step 1 of 3: Please fill in the following details to begin the installation.</p>

	<div class="control-group cf-host required">
	<label for="db_host">MySQL hostname</label>
	<div class="controls"><input class="required" id="db_host" name="db_host" size="30" type="text" value="{{db_host}}"></div>
	<div class="status-message" for="db_host"></div></div>

	<div class="control-group cf-name required">
	<label for="db_name">MySQL database name</label>
	<div class="controls"><input class="required" id="db_name" name="db_name" size="30" type="text" value="{{db_name}}"></div>
	<div class="status-message" for="db_name"></div></div>

	<div class="control-group cf-user required">
	<label for="db_user">MySQL username</label>
	<div class="controls"><input class="required" id="db_user" name="db_user" size="30" type="text" value="{{db_user}}"></div>
	<div class="status-message" for="db_user"></div></div>

	<div class="control-group cf-pass required">
	<label for="db_pass">MySQL password</label>
	<div class="controls"><input class="required" id="db_pass" name="db_pass" size="30" type="password" value="{{db_pass}}"></div>
	<div class="status-message error" for="db_pass">{{message}}</div></div>
	
	<div class="form-actions right"><a class="submit" href="#">$button</a></div>

	{{#if single}}<p>The website is in SINGLE-USER mode. Make a note of the link below. You'll need it if you wish to restart the 
	installation procedure from another web-browser or session. Otherwise remove the temporary lock file located in '/tmp'</p>
	<blockquote><a href="//{{host}}{{single}}">{{host}}{{single}}</a></blockquote>
	{{/if}}
	
	<p>The Mysql user you specify will need Create and Alter Table permissions to continue. When this setup is finished, 
you may remove these permissions.</p>
</form>
BLOCK;
		$this('setup_index')->html($html)->title('Setup Your Site');
		
		$base = $this->StaticUriModule(dirname(__DIR__));
		$this->IncludeFile($base . '/admin.css');
	}

	public function render_system() {
		$this->IncludeFile('/static/droparea/droparea.css');
		$id = $this->IncludeFile('/static/droparea/droparea.js');
		$id->depends('jquery');
		$text = $this->_module();
		$button = hook_execute_late('html.button', '', 'Save Settings', 'far fa-check-circle', 'cc-blue');
		$html = <<<BLOCK
<form method="post" action="" class="indented frm">
<h3 class="templateheader">{{page_title}}</h3>
$text
<div class="form-actions right"><a href="/admin">Back</a> | <a href="/admin/system/export?auth={{auth_exp}}" title="These settings are not stored in the database.">Export Settings</a> | <a class="submit" href="#">$button</a></div>
</form>
BLOCK;
   		$this('setup_system')->html($html)->title('System Settings');

	}
	
	// $macro cannot have leading whitespace.
	private function _module() {
		$macro = hook_execute('component.add', '', 'formedit');	
		return <<<BLOCK
{{#if fieldset}}
	{{#each fieldset}}<fieldset style="position: relative">
		<legend>&nbsp;{{name}}&nbsp;</legend>
$macro
		</fieldset>
	{{/each}}
{{else}}
$macro
{{/if}}
BLOCK;
	}

	public function render_module_settings() {
		$text = $this->_module();
		$button = hook_execute_late('html.button', '', 'Save Settings', 'far fa-check-circle', 'cc-blue');
		$html = <<<BLOCK
<form method="post" action="" class="indented frm json">
<h3 class="templateheader">{{page_title}}</h3>
$text
<div class="form-actions right"><a href="/admin/admin-create">Back</a>  <a class="submit" href="#">$button</a></div>
</form>
BLOCK;
   		$this('setup_module')->html($html)->title('Configure Module');

	}

	public function setup_showkey() {
		$html = <<<BLOCK
<form>
	<div class="control-group">
        <label for="pubkey">Public Key</label>
        <div class="controls"><textarea id="pubkey" name="pubkey" class="admin-textarea" wrap="physical" style="white-space: pre-wrap; word-break:break-all; font-family: monospace; min-height:160px;width:100%">{{pubkey}}</textarea></div>
	</div> 
</form>

BLOCK;
		$this('setup_showkey')->html($html);
	}
	
	public function render_keyinfo() {
//<h3>Generating a Private Key</h3>
		$html = <<<BLOCK
<p>The private key is used for security when administering this website.</p>

<h2>Instructions for Windows</h2>

<ul>
<li><p>Download and run PuttyGen from <a href="https://www.chiark.greenend.org.uk/~sgtatham/putty/download.html">chiark.greenend.org.uk</a>.  You'll see it near the end of 'Alternative binary files'. Use the 32-bit version.</p></li>
<li><p>At the bottom of the window, change the <em>Number of bits in a generated key</em> to <strong>512</strong></p></li>
<li><p>The Type of key to generate should be RSA.</p></li>
<li><p>Click on <em>Generate</em> to create the key and follow instructions. It will pop up a warning about being too short - continue anyway.</p></li>
<li><p>When that is complete, click on <em>Save private key</em>. Save it without a passphrase to the desktop.</p></li>
<li><p>Locate the .ppk file on the desktop, and drag it onto the Private key field on the System Settings page of this website.</p></li>
</ul>

<h2>Instructions for Linux</h2>

<p>From a shell prompt, type the following:</p>
<blockquote><pre>openssl genrsa 512</pre></blockquote>

<p>You should see something similar to the following:</p>

<blockquote><pre title="do not copy the text from this example - it will work, but not be secure">Generating RSA private key, 512 bit long modulus
..........++++++++++++
..++++++++++++
e is 65537 (0x10001)
<b style="color:#000">-----BEGIN RSA PRIVATE KEY-----
MIIBPAIBAAJBAOwrDtJ7HHtCKGCzbFog+Ru98GbHM6J9u1ahPJMfUu5yBIy378Xu
sTwxbz0II34aXl2PjY2+97aMRoRrFcKDLnUCAwEAAQJAG6dnEupriVtT0w7vbxZR
VRhGoCJPP4WtfBVhPHD8iwMBQtyA9TfCZb6eIVEUmV80jKt/IL/2/1FKr1nuXusv
eQIhAPi/zbmjZzOA/eWOphcj2G0Dx2AcApP7pUE1DxsqzoSfAiEA8w1fglZHdDT+
97PhWbs03lcLgOa5ZUnfA6/ykoy2QGsCIQDnIVlnt5QqAB5qkZx0feMYkF1OSVh/
5mBL8aBCrwjLowIhAIVq9t2uDOUuXjOMy4wdJoVSVN86R9Tg+wmkIMzvbu/nAiEA
4R1fcTY2jbH8/eeLh9h+ezDIB2Ig1oktOQGGqBP7W/E=
-----END RSA PRIVATE KEY-----</b></pre></blockquote>

<p>Copy all the text from the line 'BEGIN RSA PRIVATE KEY"  through
to the line 'END RSA PRIVATE KEY' (shown in bold black text), and paste it into the Private key field on the System Settings page of this website.</p>
<p>[If you have a .pem file with this text in it, you can also drag the file onto the Private key field]</p>

<h2>Instructions for Mac OS X</h2>

BLOCK;
   		$this('setup_keyinfo')->html($html)->title('Generating a Private Key');
	}

	public function template_confirm_email() {
		$body = <<<BLOCK
<p>Dear Who-ever,</p>

<p>A request has been sent from xyz to confirm this email address.</p>

<p>If you do not recognized this, simply delete the email.</p>

BLOCK;
		// Title
		// email subject
		// email body (html)
		return ['title' => 'Administrator Confirmation Email',
				'subject' => 'Please confirm your email address',
				'body' => $body];
	}
	
	function render_select() {
		$html = <<<BLOCK
<div class="indented">
<h3 class="templateheader">{{page_title}}</h3>
<p>The last step in the setup process is to assign an Administrator. Please choose from from one of the account providers below.</p>
<ul class="email-list list-provider">{{#each provider}}
<li><a href="{{link}}">{{{value}}}</a></li>
{{/each}}</ul>
<p>This will work - but verification code is not emailed - please check database instead. Also, the user will need to be promoted to level 10</p>
</div>

BLOCK;
   		$this('setup_select')->html($html)->title('Assign Administrator Login');
	}
	
	public function render_settings() {
		$base = $this->StaticUriModule(__DIR__);
		$this->IncludeFile("$base/module.js");
		hook_execute('component.add', FALSE, 'password');
		hook_execute('component.add', FALSE, 'datatables');		// signal that a datatables component is being used
		hook_execute('component.add', FALSE, 'contextMenu');
		$html = <<<BLOCK
<div class="normal">
	<h3 class="templateheader">{{page_title}}</h3>

	<p>The following modules have been installed. Expand the entries to view configuration settings, then click on a value to modify.</p>
	<table class="display data-class modules monitor-checkbox" ajax="/admin/settings/list" href="/admin/settings/edit">
	<thead>
	<tr>{{#each header}}
		<th>{{caption}}</th>
	{{/each}}</tr>
	</thead>
	</table>

	<a href="/admin" class="singleclick">Back</a>
	<p>Context Menus for items are only available when the module is enabled</p>
	
</div>

BLOCK;
   		$this('setup_modules')->html($html)->title('Module Settings');
	}

/*
	<tr>
		<th></th><th>Enabled</th><th>Name</th><th>Description</th><th>Version</th>
	</tr>
*/
	
}