<?php

namespace modules\config;

trait traits {

	public  $__CONFIG;
	
	public function __construct() {
		if (!isset($this->__CONFIG)) {
			if (!isset($GLOBALS['config_trait_info'])) {
				$GLOBALS['config_trait_info'] = new trait_info();
			}
			$this->__CONFIG = $GLOBALS['config_trait_info'];
		}
	}

	public function SettingGet($key, $default = NULL) {
		return $this->__CONFIG->SettingGet($key, $default);
	}

	public function SettingSet($key, $value) {
		return $this->__CONFIG->SettingSet($key, $value);
	}

}


class trait_info implements \Iterator {
	
	private $changed;
	private $attribute;
	private $keys;
	private $filename_config;
	const FILENAME = '.htconfig';
	
	public function __construct() {
		$this->filename_config = HOME . '/storage/' . self::FILENAME;
		$this->attribute = [];
		$this->keys = [];
		$this->changed = FALSE;
		$this->Load();
	}
	
	public function filename() {
		return $this->filename_config;
	}

	public function SettingGet($key, $default = NULL) {
		$key = str_replace('.', '_', $key);
		$result = $this->$key;
		return $result === NULL ? $default : $result;
	}

	public function SettingSet($key, $value) {
		$key = str_replace('.', '_', $key);
		$this->$key = $value;
	}
	
	#[\ReturnTypeWillChange]
	public function rewind() {
		reset($this->keys);
    }

	#[\ReturnTypeWillChange]
    public function current() {
		$position = current($this->keys);
		return $this->attribute[$position];
    }

	#[\ReturnTypeWillChange]
    public function key() {
		$n = current($this->keys);
        return $n;
    }

	#[\ReturnTypeWillChange]
    public function next() {
		next($this->keys);
    }

	#[\ReturnTypeWillChange]
    public function valid() {
		$position = current($this->keys);
        return isset($this->attribute[$position]);
    }
	
	function __get($name) {
		$name = str_replace('_', '.', $name);
		if (isset($this->attribute[$name])) {
			return $this->attribute[$name];
		} else {
			return NULL;
		}
	}

	function __set($name, $value) {
		$name = str_replace('_', '.', $name);
		$existing = isset($this->attribute[$name]);
		if ($existing) {
			if ($this->attribute[$name] === $value) return;
		}		
		$this->attribute[$name] = $value;
		$this->changed = TRUE;
		if (!$existing) $this->keys[] = $name;
		// send message on value changed?
	}

	function __isset($name) {
		$name = str_replace('_', '.', $name);
		return isset($this->attribute[$name]);
	}

	function __unset($name) {
		$name = str_replace('_', '.', $name);
		if (isset($this->attribute[$name])) {
			unset($this->attribute[$name]);
			$this->changed = TRUE;
			// send message on value changed?
			$this->keys = array_keys($this->attribute);
		}
	}
	
	public function Load() {
		if (file_exists($this->filename_config)) {
            $content = file_get_contents($this->filename_config);
            if (substr($content, 0, 2) == 'a:') {
                $this->attribute = unserialize($content);
            } else {
                $this->attribute = json_decode($content, TRUE);
            }
		} else {
			$this->attribute = [];
		}
		$this->keys = array_keys($this->attribute);
		$this->changed = FALSE;
	}
	public function Save() {
		if ($this->changed) {
            $content = json_encode($this->attribute, JSON_UNESCAPED_SLASHES);
			file_put_contents($this->filename_config, $content);
		}
		$this->changed = FALSE;
	}
	function __destruct() {		// save settings
		$this->Save();
	}
	
	public function __debugInfo() {
		return [];
	}
}