!function($){
	
	function _toggleCheckBox(name, action, value, $checkbox) {
		let elements = name.split('|');
		let p = action.indexOf('?');
		let param = '';
		if (p > -1) {
			param = action.substring(p);
			action = action.substring(0, p);
		}
		$.ajax({
			dataType: 'json',
			async: true,
			url: action + '/' + elements[1] + '/' + elements[2] + param,
			data: {value: value},
			type: 'POST'
		}).done(function(data) {
			if (typeof data.result != 'undefined') {
				if (data.result && data.result != -9999) {
					$checkbox.prop('checked', false);
				}
			}
			main.displayPage(data);
		});
	}
	
	function formatRow(d) {
		var line = '', i, j, key, value, output = '';
		var extra_data = d['data'];
		for(i = 0; i < extra_data.length; i++) {
			line = '';  j = 0;
			for(key in extra_data[i]) {
				j++;
				value = extra_data[i][key];
				if (value === null) {
					value = '&nbsp;';
				} else if (Array.isArray(value)) {		// first element is raw value, second is displayable version
					value = value[1];
				}
				line += '<td class="slidecol_' + j + '">' + value + '</td>';
			}
			output += '<tr>' + line + '</tr>';
		}
		
		return '<div class="slider">'+
			'<table class="slider-table" cellpadding="5" cellspacing="0" border="0" style="width:calc(100% - 190px);">'+ output+
			'</table>'+
		'</div>';
	}
	
	function _locaterow(the_table, module) {
		var result = null;
		the_table.rows().every( function ( rowIdx, tableLoop, rowLoop ) {
			var data = this.data();
			if (data.module == module) result = this;
		} );
		return result;
	}
	
	// update the extra_data structure in the database
	function _updateInternalStructure($text, module, field, value) {
		var $table = $text.closest('table.data-class');
		var phrase = 'data-field="' + field + '"';
		var the_table = $table.dataTable({'retrieve': true}).api();
		// get the row for this module
		var row = _locaterow(the_table, module);
		if (row !== null) {
			var data = row.data();
			for(var i = 0; i < data.data.length; i++) {			// rows
				if (data.data[i][1].indexOf(phrase) > -1) {		// col0 = label, col1 = data
					_updateInternalValue(data, i, value);
					row.data(data).draw();
					break;
				}
			}
		}
	}
		
	function _updateInternalValue(structure, rownum, new_value) {
		new_value = escapeHtml(new_value);
		let html = structure.data[rownum][1];
		html = html.replace(/">.*<\/b>$/, '">' + new_value + '</b>');
		structure.data[rownum][1] = html;
	}
		
	$(document).on('editable:config', function(event, element, value, settings) {
		var $text = $(element);
		var module = element.dataset.module;
		var field = element.dataset.field;
		if (typeof field != 'undefined') {
			_updateInternalStructure($text, module, field, value);
		}
		var action = $text.attr('href');
		$.ajax({
			dataType: 'json',
			async: true,
			url: action,
			data: {value: value},
			type: 'POST'
		}).done(function(data) {
			main.displayPage(data);
		});
		return value;
	});
	
// an addon is being enabled or disabled
	// or a setting within the addon is being checked
	$(document).on('click', 'table.monitor-checkbox input.checkbox-edit', function(event) {
		var $checkbox = $(this);
		var $table = $checkbox.closest('table');
		var href = $table.attr('href');
		var name = $checkbox.attr('name');
		_toggleCheckBox(name, href, this.checked ? $checkbox.val() : 0, $checkbox);
		
	}).on('click', 'table.monitor-checkbox input.checkbox-input', function(event) {
		var $checkbox = $(this);
		var href = $checkbox.attr('href');
		var value = $checkbox.prop('checked') ? 1 : 0;
		$.ajax({
			dataType: 'json',
			async: true,
			url: href,
			data: {value: value},
			type: 'POST'
		}).done(function(data) {
			main.displayPage(data);
		});
		
	}).on('click', 'td.details-control', function () {
		var $table = $(this).closest('table');
		var the_table = $table.dataTable({'retrieve': true}).api();
		var tr = $(this).closest('tr');
		var row = the_table.row( tr );
 
		if ( row.child.isShown() ) {
			// This row is already open - close it
			$('div.slider', row.child()).slideUp( function () {
				row.child.hide();
				tr.removeClass('shown');
			} );
		} else {
			// Open this row
			var x = row.child( formatRow(row.data()), 'no-padding' );
			var y = row.child();
			$(document).triggerHandler('loaded.datatables', [$table, y]);		// add the inline editor
			main.attachEditable(y);
			x.show();
			tr.addClass('shown');
			$('div.slider', row.child()).slideDown();
		}
	});

}(jQuery);