<?php

namespace modules\config;

// handle the output object

class module_info extends \module {

	function __info() {
		$host = strtolower($_SERVER['HTTP_HOST'] ?? '');
		$x = explode('.', $host);
		if ($x[0] == 'www') array_shift($x);
		$host = join('.', $x);

		return [
			'version' => '2026.1.7',
			'required' => TRUE,
			'class' => 'modules\\config\\main',
			'name' => 'System Settings',
			'depends' => ['phpseclib', 'datatables', 'formEdit', 'contextMenu', 'input', 'composer'],
			'display_order' => 1,
			'settings' => [
				[
					'name' => 'companyname',
					'type' => 'string',
					'caption' => 'Website or Company name',
				], [
					'name' => 'replyto',
					'type' => 'string',
					'caption' => 'Reply-To Address for System Emails',
					'default' => 'do-not-reply@' . $host,
				], [
					'name' => 'defaultdate',
					'caption' => 'Default Date Format',
					'type' => 'select',
					'options'  => ['mdy' => 'mm/dd/yyyy',
									'dmy' => 'dd/mm/yyyy',
									'ymd' => 'yyyy/mm/dd'],
				], [
					'name' => 'key',
					'caption' => '512-bit Private Key',
					'type' => 'text',
					'status'  => '<a href="/admin/createkey" class="json-request">Create New Key</a> | ' .		// uses phpseclib. url not updated
								'<a href="/admin/keyinfo" target="_blank">help with private keys</a> | ' .
								'<a href="/admin/showkey" class="json-request">show public key</a>',
													'class' => 'filedrop font-fixedwidth',
				],
			],
			'email' => [	// internal name  => entrypoint
							'confirm' => 'modules\\config\\view\\setup_view::template_confirm_email'
						]
		];
	}
	
	// load/store module config settings
	// initial setup procedure

}

