<?php

class Composer_View extends View {
	
	public function render_check() {
		$button0 = hook_execute_late('html.button', '', 'No', 'fas fa-times-circle', 'cc-blue');
		$button1 = hook_execute_late('html.button', '', 'Yes', 'far fa-check-circle', 'cc-blue');
		$html = <<<BLOCK
<div class="indented">
<h3 class="templateheader">{{page_title}}</h3>

<p>There is a new version of Composer available. Do you wish to install it?</p>

<p>Current version: <strong>{{version_current}}</strong><br>
New version: <strong>{{version_new}}</strong></p>

<p><a href="/admin/composer/dependencies{{#if param}}?param={{param}}{{/if}}">$button0</a> &nbsp;
   <a href="/admin/composer/upgrade{{#if param}}?param={{param}}{{/if}}">$button1</a></p>


BLOCK;
		$this('composer_check')->html($html)->title('New Version Available');
	}
	
	public function render_iframe() {
		// this depends on header height :(
		$css = <<<BLOCK
.iframe-co {
	width: 100%;
	border: 1px dashed #ccc;
	height: calc(100vh - 300px);
	min-height: 300px;
	overflow: scroll;
}
BLOCK;
		$id = $this->IncludeFile('');
		$id->AddCSS($css);
		
		$html = <<<BLOCK
<div class="indented">
<h3 class="templateheader">{{page_title}}</h3>
<iframe class="iframe-co" frameborder="0" cols="100" rows="15" src="/admin/composer/upgrade-iframe{{#if param}}?param={{param}}{{/if}}"></iframe>
BLOCK;
		$this('composer_iframe')->html($html)->title('Installing Composer');
	}

	public function render_iframe2() {
		// this depends on header height :(
		$css = <<<BLOCK
.iframe-co {
	width: 100%;
	border: 1px dashed #ccc;
	height: calc(100vh - 300px);
	min-height: 300px;
	overflow: scroll;
}
BLOCK;
		$id = $this->IncludeFile('');
		$id->AddCSS($css);
		
		$html = <<<BLOCK
<div class="indented">
<h3 class="templateheader">{{page_title}}</h3>
<iframe class="iframe-co" frameborder="0" cols="100" rows="15" src="/admin/composer/package-iframe{{#if param}}?param={{param}}{{/if}}"></iframe>
BLOCK;
		$this('composer_iframe2')->html($html)->title('Updating Packages');
	}
	
}
