<?php

namespace modules\composer;

class main extends \moduleMain {

	public function __construct() {
		parent::__construct(__DIR__);
	}

	public function Activate() {
		if (file_exists(HOME . '/vendor/autoload.php')) {
			require_once HOME . '/vendor/autoload.php';
		}
		hook_add('menu.admin', [$this, '__admin_menu']);
		// if this module were to be activated, what composer modules would be needed to be installed
		hook_add('module.verify', [$this, '__module_verify']);
	}

	public function __admin_menu(&$menu) {
		$menu[] = [
				'caption' => 'Composer Dependencies', 
				'href' => '/admin/composer', 
				'hint' => 'Install or Upgrade Composer requirements',
				'icon' => '<i class="pkp pkp-composer"></i>',		// should be a composer icon
				's' => 0
			];
	}
	
	// a module is to be enabled - do we allow it? - return a noty if not
	public function __module_verify(&$result, $module) {
		if (is_array($result)) return;		// another module has failed to verify
		
		$this->model_composer = $this->loadModel('composer_model');
		$list = $this->model_composer->GetMissingPackages($module);
		if (count($list['require'])) {
			$hash = $GLOBALS['loader']->CreateEphemeral([
				'action' => 'composer-package',
				'list' => $list,
			]);
			// save as Ephemeral item
			$result = [	'result' => -1622,
						'message' => "Prerequistes for this module are not installed. <a href=\"/admin/composer?param={$hash}\">Install now</a>"];
		}
		// otherwise do nothing -- it passes this check, move on to the next
	}

}