<?php

class pages_history extends Database_model {
	protected $tablename = 'pages_history';

	public function __construct() {
		parent::__construct();
	}
	
	public function LoadPreview($ph_id) {
		$sql = <<<BLOCK
select pages_history.*, name_first, name_last
  from pages_history 
	left join users on pg_owner=user_id
BLOCK;
		$data = $this->Query($sql)
			->Where('ph_ispreview=1')
			->Where('ph_id=%d', $ph_id)
			->Get()
			->First();
		$this->DbErr();
		if (is_null($data) || $data->empty()) {
			$data->__extra = unserialize($data->pg_extra);
		} else {
			$data->__extra = [];
		}
		return $data;
	}

	public function GetPreviewAuth($data) {
		$auth = md5($data->ph_timestamp . ':' . $data->pg_title . ':' . $data->ph_id);
		return $auth;
	}
	
	public function SaveHistory($old) {		// always create new record

		$this->TableName('pages_history')
			->AutoInc('ph_id')
			->InsertOrUpdate([
				'ph_id'			=> NULL,
			],[
				'pg_uri'		=> $old->pg_uri,
				'pg_title'		=> $old->pg_title,
				'pg_owner'		=> $old->pg_owner,
				'pg_modified'	=> $old->pg_modified,
				'pg_text'		=> $old->pg_text,
				'pg_extra'		=> $old->pg_extra,
				'ph_timestamp'	=> gmdate('Y-m-d H:i:s'),
				'ph_ispreview'	=> 0,
		]);
	}
	
	public function SavePreview($new) {
		$cutoff = date('Y-m-d H:i:s', time() - 7 * 86400);
		$this->Query('delete from pages_history')
				->Where('ph_ispreview=1')
				->Where('ph_timestamp<%s', $cutoff)
				->Get();

		$data = $this->TableName('pages_history')
			->AutoInc('ph_id')
			->InsertOrUpdate([
				'ph_id'			=> NULL,
			],[
				'pg_uri'		=> $new->pg_uri,
				'pg_title'		=> $new->pg_title,
				'pg_owner'		=> $new->pg_owner,
				'pg_modified'	=> $new->pg_modified,
				'pg_text'		=> $new->pg_text,
				'pg_extra'		=> $new->pg_extra,
				'ph_timestamp'	=> gmdate('Y-m-d H:i:s'),
				'ph_ispreview'	=> 1,
		]);
		return $data->ph_id;
	}
	
}