<?php

namespace modules\cms;

class module_info extends \module {

	function __info() {  
		return [
			'version' => '2026.1.5',
			'required' => FALSE,
			'class' => 'modules\\cms\\main',
			'name' => 'Content Management System',
			'depends' => ['input', 'config', 'database', 'output', 'htmlEdit'],
			'database' =>  [
				'pages' => [
					'engine' => 'auto',
					'charset' => 'utf-8',
					'comment' => 'cms pages',
					'fields' => [
						[
							'name' => 'pg_uri',
							'type' => 'string',
							'size' => 128,
							'null' => FALSE,
						],
						[
							'name' => 'pg_title',
							'type' => 'string',
							'size' => 512,
							'null' => FALSE,
						],
						[ 
							'name' => 'pg_owner',
							'type' => 'string',
							'size' => 16,
							'null' => FALSE,
						],
						[ 
							'name' => 'pg_modified',
							'type' => 'time',
							'null' => FALSE,
							'default' => 'NOW'
						],
						[
							'name' => 'pg_text',
							'type' => 'text',
							'null' => FALSE,
						],
						[ 
							'name' => 'pg_extra',
							'type' => 'object',
							'comment' => 'addon specific extras',
						],
					// date created, date last logged in?
					],
					'index' => ['PRIMARY' => [	'type' => 'primary',
												'fields' => ['pg_uri'],
											],
								'byOwner' => [	'type' => 'index',
												'fields' => ['pg_owner','pg_modified'],
											],			
								],
					],
				'pages_history' => [
						'engine' => 'auto',
						'charset' => 'utf-8',
						'comment' => 'previous cms pages',
						'fields' => [
							[ 
								'name' => 'ph_id',
								'type' => 'int',
								'size' => 11,
								'null' => FALSE,
								'autoinc' => TRUE,
							],
							[ 
								'name' => 'ph_timestamp',
								'type' => 'time',
								'null' => FALSE,
								'default' => '1980-01-01 00:00:00',
							],
							[ 
								'name' => 'ph_ispreview',
								'type' => 'int',
								'null' => FALSE,
								'default' => '0'
							],
							[ 
								'name' => 'pg_uri',
								'type' => 'string',
								'size' => 128,
								'null' => FALSE,
							],
							[ 
								'name' => 'pg_title',
								'type' => 'string',
								'size' => 512,
								'null' => FALSE,
							],
							[ 
								'name' => 'pg_owner',
								'type' => 'string',
								'size' => 16,
								'null' => FALSE,
							],
							[ 
								'name' => 'pg_modified',
								'type' => 'time',
								'null' => FALSE,
								'default' => 'NOW',		// cunrrent_timestamp
							],
							[ 
								'name' => 'pg_text',
								'type' => 'text',
								'null' => FALSE,
							],
							[ 
								'name' => 'pg_extra',
								'type' => 'text',
								'comment' => 'addon specific extras',
								'serialized' => TRUE
							],
							// date created, date last logged in?
						],
						'index' => [
									'primary' => [	'type' => 'primary',
													'fields' => ['ph_id'] 
												 ],
									'byUri' =>  [	'type' => 'index',
													'fields' => ['pg_uri','ph_timestamp'],
												],
									'ispreview' =>  [	'type' => 'index',
													'fields' => ['ph_ispreview','pg_uri'],
												],
									'byOwner' => [	'type' => 'index',
													'fields' => ['pg_owner','pg_modified'],
												],			
									],
						],
				]
		];
	}
}
