<?php
	
class cms_admin extends Controller {
	
	public function __construct() {
		parent::__construct(dirname(__DIR__));
	}

	public function __Register() {
		$this->RegisterView(__CLASS__ .'::email', ['cms_admin_view' => ['render_email']]);
		$this->RegisterView(__CLASS__ .'::cms_pages', ['cms_admin_view' => ['admin_cmspages']]);
	}
	
	/** staff */
	public function email($param = '') {
		// with no parameters - display list of active email templates - use email settings from index - see config/index.php for example
		//			load view files
		//				display modified email templates as bold
		//			get last-mod date from database
		//   with parameter - edit email template
		$res = $this->DefaultResult(__METHOD__);

		if ($param == '') {
			$model = $this->LoadModel('cms_model');
			$active_templates = $GLOBALS['loader']->EmailTemplates_List();
			$res['emails'] = $model->getEmailLinks($active_templates);
			$res['template'] = 'admin_email';
			return $res;
		}	// when param specified, modules\cms\main.php will pick up the page
		return $res;
	}

	/** staff */
	public function cms_pages($page = '') {
		$res = $this->DefaultResult(__METHOD__);
// get list of pages - 
		$model = $this->LoadModel('cms_model');
		$res['template'] = 'admin_cmspages';
		$res['datatable'] = $model->datatable_pagelist();
// edit to go to the specific page
		return $res;
	}
}