<?php

class account_view extends View {
	
	
	public function render_invite() {    
		$html = <<<BLOCK
<div class="indented">
<h3 class="templateheader">{{page_title}}</h3>

<p>Welcome to the website. To continue, please create an account on this site by completing the form below, or use one of the Authentication Providers on the right.</p>
<div class="main-body">
	<div class="column main-column">
{{> register}}
	</div>
	<div class="column main-right">
		<ul class="email-list list-provider">{{#each provider}}
		  <li><a href="{{link}}">{{{value}}}</a></li>
		{{/each}}<li>None of the Above...</li></ul>
	</div>
</div>

</div>
BLOCK;
		$this('account_invite')->html($html)->title('Invitation to Join');
	}

	public function render_inviter() {
		$html = <<<BLOCK
<div class="indented">
<h3 class="templateheader">{{page_title}}</h3>

<p>Please select the features you wish the invited team member to have:</p>
<li>Access to your domains</li>
<li>File System Access</li>
<li>Create and Edit CMS pages</li>
</div>	
BLOCK;
		$this('account_invite')->html($html)->title('Invite Others to Join');
	}
	
	
	// select an account, or create a new one
	public function render_list() {
		hook_execute('component.add', FALSE, 'datatables');		// signal that a datatables component is being used
		$html = <<<BLOCK
<div class="indented">
<h3 class="templateheader">{{page_title}}</h3>
<p>Select an account from the list below, or create a <a href="/account/new">new</a> one.</p>
	<table class="display data-class" ajax="/account/list/all">
	<thead>
	<tr>{{#each header}}
		<th>{{caption}}</th>
	{{/each}}</tr>
	</thead>
	</table>

</div>
BLOCK;
		$this('account_list')->html($html)->title('Accounts');
	}	
	
	// create new account
	public function render_new() {
		hook_execute('component.add', FALSE, 'password');
		$macro = hook_execute('component.add', '', 'formedit');	
		$button = hook_execute_late('html.button', '', 'Create Account', '', 'cc-blue');
		$html = <<<BLOCK
<div class="indented">
<h3 class="templateheader">{{page_title}}</h3>
<form class="frm json" method="post">
	$macro

	<div class="form-actions right"><a class="submit" href="#">$button</a></div>
	<br /><br />
</form>
</div>
BLOCK;
		$this('account_new')->html($html)->title('Set up a New Account');
	}	
	
	// account settings
	// to do: specify a prefix for fieldset - add to all "name" parameters
	// to do: invite button only displayed for toplevel users
	public function render_edit() {
		$button = hook_execute_late('html.button', '', 'Update', 'far fa-check-circle', 'cc-blue');
		$button_i = hook_execute_late('html.button', '', 'Invite...', 'far fa-envelope', 'cc-blue');
		$extras = hook_execute_late('account.actions', '');
//		hook_execute('component.add', '', 'password');
		$macro = hook_execute('component.add', '', 'formedit');
		$html = <<<BLOCK
<div class="indented">
<h3 class="templateheader">{{page_title}}</h3>
<form class="frm json" method="post">
	<input type="hidden" name="id" value="{{id}}">
	<input type="hidden" name="auth" value="{{auth}}">
	<input type="hidden" name="action" value="" id="submit_action">
	$macro
{{#if can_lock}}
	<label><input type="checkbox" name="is_locked" value="1" {{ is_locked }}> Lock Account?</label>
{{/if}}
	<div class="form-actions right">$extras
		<a class="submit" for="submit_action" data-value="invite" href="#">$button_i</a> &nbsp;
		<a class="submit" for="submit_action" data-value="update" href="#">$button</a>
	</div>
	<br /><br />
</form>
</div>
BLOCK;
		$this('account_edit')->html($html)->title('Edit Profile');
	}

	// account settings
	// to do: specify a prefix for fieldset - add to all "name" parameters
	// to do: invite button only displayed for toplevel users
	public function render_view() {
//		hook_execute('component.add', '', 'password');
		$macro = hook_execute('component.add', '', 'formedit');
		$html = <<<BLOCK
<div class="indented">
<h3 class="templateheader">{{page_title}}</h3>
<form class="frm json" method="post">
	$macro
	<br /><br />
</form>
</div>
BLOCK;
		$this('account_view')->html($html)->title('Profile');
	}

	
	public function render_invitepopup() {
		//to do: add id and auth
		$button_i = hook_execute_late('html.button', '', 'Send Invite', 'fa-envelope-o', 'cc-blue');
		$html = <<<BLOCK
<form class="frm json" method="post">
	<p>Please enter an email address for the person you wish to invite</p>
	<input type="hidden" name="id" value="{{id}}">
	<input type="hidden" name="auth" value="{{auth}}">
	<input type="hidden" name="action" value="send-invite" id="submit_action">
	<div class="control-group cf-email">
		<label for="email">Email Address</label>
		<div class="controls"><input id="email" name="email" size="30" value="" type="text"></div>
		<div class="status-message" for="email"></div>
	</div>
	<div class="form-actions right">
		<a class="submit" href="#">$button_i</a>
	</div>
</form>
BLOCK;
		$this('account_invitepop')->html($html);
	}
	
	public function template_invite_email() {
		$body = <<<BLOCK
<p>Hi Xyz,</p>

<p>You have been invited by www to join xxx at yyy</p>

<p>To create an account, please <a href="{{link}}">follow this link</a>. Otherwise, if you do not recognize this email, simply delete it.</p>

BLOCK;
		// Title
		// email subject
		// email body (html)
		return ['title' => 'Invitation to Join',
				'subject' => 'Invitation to Join',
				'body' => $body];
	}

	
}