<?php

namespace modules\account;

class main extends \moduleMain {

	public function __construct() {
		parent::__construct(__DIR__);
		$this->level = isset($_SESSION['current_user']) ? $_SESSION['current_user']['u_level'] : 0;
	}

	public function Activate() {
		hook_add('user.data', [$this, '__user_data']);
		hook_add('menu.admin', [$this, '__admin_menu'], 95);
        hook_add('config.get', [$this, '__user_preferences'], 90);      // get per-user preferences
        hook_add('config.set', [$this, '__set_user_preferences'], 10);  // set per-user preferences
	}
	
	final function test() {
		header('Content-type: text/plain');
		$css = <<<BLOCK
a {
	color: #900;
	text-decoration: none;
}
BLOCK;
		
		$data = ['link' => 'the-link-goes-here'];
		$m = new \mailobject();
		$m->template('account::invite')
			->to('"Dr Joe Black" <dr.joe.b@gmail.com>')
			->css($css)
			->data($data)
			->Send();
		exit;
	}
	
	public function __admin_menu(&$menu) {
		$menu[] = [
				'caption' => 'User Maintenance', 
				'href' => '/account/list', 
				'hint' => 'Create and Edit Users',
				'icon' => '<i class="fas fa-users-cog"></i>',
				's' => 0
			];
	}

	// ??get user-specific configuration settings
	public function __user_data(&$result, $user_id, $data_prefix) {
		if ($result === NULL) {
			$this->account_model = $this->loadModel('account_model');
			$this->account_model->UserSettingsGet($result, $data_prefix, $user_id);
// to fix:
//			$result = $this->account_model->GetUserData($user_id, $data_prefix);
//			$temp = $this->account_model->GetUserData($user_id, $data_prefix);
		}
	}

	public function __user_preferences(&$data, $module_name, $user_id = 0) {
		if ($module_name != 'config') {
			$this->account_model = $this->loadModel('account_model');
            $this->account_model->UserSettingsGet($data, $module_name, $user_id);
		}
	}
	
	public function __set_user_preferences(&$data, $module_name) {
		if ($module_name != 'config') {
			$this->account_model = $this->loadModel('account_model');
            $this->account_model->UserSettingsSet($data, $module_name);
		}
	}	

}
