<?php

namespace modules\account;


class module_info extends \module {

	function __info() {  
		return [
			'version' => '2025.4.2',
			'required' => FALSE,
			'class' => 'modules\\account\\main',
			'name' => 'User Accounts',
			'depends' => ['database', 'formEdit', 'input', 'output', 'config'],
			'email' => [	// internal name  => entrypoint
							'invite' => 'modules\\account\\view\\account_view::template_invite_email'
						],
			'database' =>  [
				'users_data' => [
					'engine' => 'auto',
					'charset' => 'utf-8',
					'comment' => 'User Settings',
					'fields' => [
						[
							'name' => 'ud_user_id',
							'type' => 'int',
							'size' => 11,
							'null' => FALSE,
						],[
							'name' => 'ud_key',
							'type' => 'string',
							'size' => 80,
							'null' => FALSE,
						],[
							'name' => 'ud_value',
							'type' => 'int',
							'size' => 11,
							'null' => TRUE,
						],[
							'name' => 'ud_text',
							'type' => 'text',
							'encrypted' => TRUE,
							'null' => TRUE,
						],
						// date created, date last logged in?
					],
					'index' => [
						'PRIMARY' => [	'type' => 'primary',
										'fields' => ['ud_user_id', 'ud_key'],
									],
					],
				],
				'users_invite' => [
					'engine' => 'auto',
					'charset' => 'utf-8',
					'comment' => 'User Invitations',
					'fields' => [
						[
							'name' => 'ui_hash',
							'type' => 'string',
							'size' => 64,
							'null' => FALSE,
						],[
							'name' => 'ui_date',
							'type' => 'int',
							'size' => 11,
							'unsigned' => TRUE,
							'null' => FALSE,
						],[
							'name' => 'ui_user_id',
							'type' => 'int',
							'size' => 11,
							'unsigned' => TRUE,
							'null' => FALSE,
						],[
							'name' => 'ui_email',
							'type' => 'string',
							'size' => 1024,
							'encrypted' => TRUE,
							'null' => FALSE,
						],
					],
					'index' => [
						'PRIMARY' => [	'type' => 'primary',
										'fields' => ['ui_hash'],
									],
						'byDate' => [	'type' => 'index',
										'fields' => ['ui_date'],
									],
					],
				]
			]
		];
	}
	
}
